// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/notification_service.proto

#include "google/cloud/monitoring/internal/notification_channel_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/monitoring/v3/notification_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

NotificationChannelServiceMetadata::NotificationChannelServiceMetadata(
    std::shared_ptr<NotificationChannelServiceStub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::monitoring::v3::ListNotificationChannelDescriptorsResponse>
NotificationChannelServiceMetadata::ListNotificationChannelDescriptors(
    grpc::ClientContext& context,
    google::monitoring::v3::ListNotificationChannelDescriptorsRequest const&
        request) {
  SetMetadata(context, "name=" + request.name());
  return child_->ListNotificationChannelDescriptors(context, request);
}

StatusOr<google::monitoring::v3::NotificationChannelDescriptor>
NotificationChannelServiceMetadata::GetNotificationChannelDescriptor(
    grpc::ClientContext& context,
    google::monitoring::v3::GetNotificationChannelDescriptorRequest const&
        request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetNotificationChannelDescriptor(context, request);
}

StatusOr<google::monitoring::v3::ListNotificationChannelsResponse>
NotificationChannelServiceMetadata::ListNotificationChannels(
    grpc::ClientContext& context,
    google::monitoring::v3::ListNotificationChannelsRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->ListNotificationChannels(context, request);
}

StatusOr<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceMetadata::GetNotificationChannel(
    grpc::ClientContext& context,
    google::monitoring::v3::GetNotificationChannelRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetNotificationChannel(context, request);
}

StatusOr<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceMetadata::CreateNotificationChannel(
    grpc::ClientContext& context,
    google::monitoring::v3::CreateNotificationChannelRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->CreateNotificationChannel(context, request);
}

StatusOr<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceMetadata::UpdateNotificationChannel(
    grpc::ClientContext& context,
    google::monitoring::v3::UpdateNotificationChannelRequest const& request) {
  SetMetadata(context, "notification_channel.name=" +
                           request.notification_channel().name());
  return child_->UpdateNotificationChannel(context, request);
}

Status NotificationChannelServiceMetadata::DeleteNotificationChannel(
    grpc::ClientContext& context,
    google::monitoring::v3::DeleteNotificationChannelRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->DeleteNotificationChannel(context, request);
}

Status
NotificationChannelServiceMetadata::SendNotificationChannelVerificationCode(
    grpc::ClientContext& context,
    google::monitoring::v3::
        SendNotificationChannelVerificationCodeRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->SendNotificationChannelVerificationCode(context, request);
}

StatusOr<google::monitoring::v3::GetNotificationChannelVerificationCodeResponse>
NotificationChannelServiceMetadata::GetNotificationChannelVerificationCode(
    grpc::ClientContext& context,
    google::monitoring::v3::GetNotificationChannelVerificationCodeRequest const&
        request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetNotificationChannelVerificationCode(context, request);
}

StatusOr<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceMetadata::VerifyNotificationChannel(
    grpc::ClientContext& context,
    google::monitoring::v3::VerifyNotificationChannelRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->VerifyNotificationChannel(context, request);
}

void NotificationChannelServiceMetadata::SetMetadata(
    grpc::ClientContext& context, std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void NotificationChannelServiceMetadata::SetMetadata(
    grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_internal
}  // namespace cloud
}  // namespace google
