// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/notification_service.proto

#include "google/cloud/monitoring/internal/notification_channel_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/monitoring/v3/notification_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

NotificationChannelServiceLogging::NotificationChannelServiceLogging(
    std::shared_ptr<NotificationChannelServiceStub> child,
    TracingOptions tracing_options, std::set<std::string> components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      components_(std::move(components)) {}

StatusOr<google::monitoring::v3::ListNotificationChannelDescriptorsResponse>
NotificationChannelServiceLogging::ListNotificationChannelDescriptors(
    grpc::ClientContext& context,
    google::monitoring::v3::ListNotificationChannelDescriptorsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::monitoring::v3::
                 ListNotificationChannelDescriptorsRequest const& request) {
        return child_->ListNotificationChannelDescriptors(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::v3::NotificationChannelDescriptor>
NotificationChannelServiceLogging::GetNotificationChannelDescriptor(
    grpc::ClientContext& context,
    google::monitoring::v3::GetNotificationChannelDescriptorRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::monitoring::v3::GetNotificationChannelDescriptorRequest const&
              request) {
        return child_->GetNotificationChannelDescriptor(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::v3::ListNotificationChannelsResponse>
NotificationChannelServiceLogging::ListNotificationChannels(
    grpc::ClientContext& context,
    google::monitoring::v3::ListNotificationChannelsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::monitoring::v3::ListNotificationChannelsRequest const&
                 request) {
        return child_->ListNotificationChannels(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceLogging::GetNotificationChannel(
    grpc::ClientContext& context,
    google::monitoring::v3::GetNotificationChannelRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::monitoring::v3::GetNotificationChannelRequest const&
                 request) {
        return child_->GetNotificationChannel(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceLogging::CreateNotificationChannel(
    grpc::ClientContext& context,
    google::monitoring::v3::CreateNotificationChannelRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::monitoring::v3::CreateNotificationChannelRequest const&
                 request) {
        return child_->CreateNotificationChannel(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceLogging::UpdateNotificationChannel(
    grpc::ClientContext& context,
    google::monitoring::v3::UpdateNotificationChannelRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::monitoring::v3::UpdateNotificationChannelRequest const&
                 request) {
        return child_->UpdateNotificationChannel(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status NotificationChannelServiceLogging::DeleteNotificationChannel(
    grpc::ClientContext& context,
    google::monitoring::v3::DeleteNotificationChannelRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::monitoring::v3::DeleteNotificationChannelRequest const&
                 request) {
        return child_->DeleteNotificationChannel(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status
NotificationChannelServiceLogging::SendNotificationChannelVerificationCode(
    grpc::ClientContext& context,
    google::monitoring::v3::
        SendNotificationChannelVerificationCodeRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::monitoring::v3::
              SendNotificationChannelVerificationCodeRequest const& request) {
        return child_->SendNotificationChannelVerificationCode(context,
                                                               request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::v3::GetNotificationChannelVerificationCodeResponse>
NotificationChannelServiceLogging::GetNotificationChannelVerificationCode(
    grpc::ClientContext& context,
    google::monitoring::v3::GetNotificationChannelVerificationCodeRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::monitoring::v3::
                 GetNotificationChannelVerificationCodeRequest const& request) {
        return child_->GetNotificationChannelVerificationCode(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceLogging::VerifyNotificationChannel(
    grpc::ClientContext& context,
    google::monitoring::v3::VerifyNotificationChannelRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::monitoring::v3::VerifyNotificationChannelRequest const&
                 request) {
        return child_->VerifyNotificationChannel(context, request);
      },
      context, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_internal
}  // namespace cloud
}  // namespace google
