// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/notification_service.proto

#include "google/cloud/monitoring/internal/notification_channel_connection_impl.h"
#include "google/cloud/monitoring/internal/notification_channel_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

NotificationChannelServiceConnectionImpl::
    NotificationChannelServiceConnectionImpl(
        std::unique_ptr<google::cloud::BackgroundThreads> background,
        std::shared_ptr<monitoring_internal::NotificationChannelServiceStub>
            stub,
        Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options),
          monitoring_internal::NotificationChannelServiceDefaultOptions(
              NotificationChannelServiceConnection::options()))) {}

StreamRange<google::monitoring::v3::NotificationChannelDescriptor>
NotificationChannelServiceConnectionImpl::ListNotificationChannelDescriptors(
    google::monitoring::v3::ListNotificationChannelDescriptorsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<monitoring::NotificationChannelServiceRetryPolicy const>(
          retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency =
      idempotency_policy()->ListNotificationChannelDescriptors(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::monitoring::v3::NotificationChannelDescriptor>>(
      std::move(request),
      [stub, retry, backoff, idempotency,
       function_name](google::monitoring::v3::
                          ListNotificationChannelDescriptorsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::monitoring::v3::
                    ListNotificationChannelDescriptorsRequest const& request) {
              return stub->ListNotificationChannelDescriptors(context, request);
            },
            r, function_name);
      },
      [](google::monitoring::v3::ListNotificationChannelDescriptorsResponse r) {
        std::vector<google::monitoring::v3::NotificationChannelDescriptor>
            result(r.channel_descriptors().size());
        auto& messages = *r.mutable_channel_descriptors();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::monitoring::v3::NotificationChannelDescriptor>
NotificationChannelServiceConnectionImpl::GetNotificationChannelDescriptor(
    google::monitoring::v3::GetNotificationChannelDescriptorRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetNotificationChannelDescriptor(request),
      [this](
          grpc::ClientContext& context,
          google::monitoring::v3::GetNotificationChannelDescriptorRequest const&
              request) {
        return stub_->GetNotificationChannelDescriptor(context, request);
      },
      request, __func__);
}

StreamRange<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceConnectionImpl::ListNotificationChannels(
    google::monitoring::v3::ListNotificationChannelsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<monitoring::NotificationChannelServiceRetryPolicy const>(
          retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListNotificationChannels(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::monitoring::v3::NotificationChannel>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::monitoring::v3::ListNotificationChannelsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::monitoring::v3::ListNotificationChannelsRequest const&
                    request) {
              return stub->ListNotificationChannels(context, request);
            },
            r, function_name);
      },
      [](google::monitoring::v3::ListNotificationChannelsResponse r) {
        std::vector<google::monitoring::v3::NotificationChannel> result(
            r.notification_channels().size());
        auto& messages = *r.mutable_notification_channels();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceConnectionImpl::GetNotificationChannel(
    google::monitoring::v3::GetNotificationChannelRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetNotificationChannel(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::GetNotificationChannelRequest const&
                 request) {
        return stub_->GetNotificationChannel(context, request);
      },
      request, __func__);
}

StatusOr<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceConnectionImpl::CreateNotificationChannel(
    google::monitoring::v3::CreateNotificationChannelRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateNotificationChannel(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::CreateNotificationChannelRequest const&
                 request) {
        return stub_->CreateNotificationChannel(context, request);
      },
      request, __func__);
}

StatusOr<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceConnectionImpl::UpdateNotificationChannel(
    google::monitoring::v3::UpdateNotificationChannelRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateNotificationChannel(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::UpdateNotificationChannelRequest const&
                 request) {
        return stub_->UpdateNotificationChannel(context, request);
      },
      request, __func__);
}

Status NotificationChannelServiceConnectionImpl::DeleteNotificationChannel(
    google::monitoring::v3::DeleteNotificationChannelRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteNotificationChannel(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::DeleteNotificationChannelRequest const&
                 request) {
        return stub_->DeleteNotificationChannel(context, request);
      },
      request, __func__);
}

Status NotificationChannelServiceConnectionImpl::
    SendNotificationChannelVerificationCode(
        google::monitoring::v3::
            SendNotificationChannelVerificationCodeRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SendNotificationChannelVerificationCode(request),
      [this](
          grpc::ClientContext& context,
          google::monitoring::v3::
              SendNotificationChannelVerificationCodeRequest const& request) {
        return stub_->SendNotificationChannelVerificationCode(context, request);
      },
      request, __func__);
}

StatusOr<google::monitoring::v3::GetNotificationChannelVerificationCodeResponse>
NotificationChannelServiceConnectionImpl::
    GetNotificationChannelVerificationCode(
        google::monitoring::v3::
            GetNotificationChannelVerificationCodeRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetNotificationChannelVerificationCode(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::
                 GetNotificationChannelVerificationCodeRequest const& request) {
        return stub_->GetNotificationChannelVerificationCode(context, request);
      },
      request, __func__);
}

StatusOr<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceConnectionImpl::VerifyNotificationChannel(
    google::monitoring::v3::VerifyNotificationChannelRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->VerifyNotificationChannel(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::VerifyNotificationChannelRequest const&
                 request) {
        return stub_->VerifyNotificationChannel(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_internal
}  // namespace cloud
}  // namespace google
