// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/notification_service.proto

#include "google/cloud/monitoring/internal/notification_channel_auth_decorator.h"
#include <google/monitoring/v3/notification_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

NotificationChannelServiceAuth::NotificationChannelServiceAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<NotificationChannelServiceStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::monitoring::v3::ListNotificationChannelDescriptorsResponse>
NotificationChannelServiceAuth::ListNotificationChannelDescriptors(
    grpc::ClientContext& context,
    google::monitoring::v3::ListNotificationChannelDescriptorsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListNotificationChannelDescriptors(context, request);
}

StatusOr<google::monitoring::v3::NotificationChannelDescriptor>
NotificationChannelServiceAuth::GetNotificationChannelDescriptor(
    grpc::ClientContext& context,
    google::monitoring::v3::GetNotificationChannelDescriptorRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetNotificationChannelDescriptor(context, request);
}

StatusOr<google::monitoring::v3::ListNotificationChannelsResponse>
NotificationChannelServiceAuth::ListNotificationChannels(
    grpc::ClientContext& context,
    google::monitoring::v3::ListNotificationChannelsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListNotificationChannels(context, request);
}

StatusOr<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceAuth::GetNotificationChannel(
    grpc::ClientContext& context,
    google::monitoring::v3::GetNotificationChannelRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetNotificationChannel(context, request);
}

StatusOr<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceAuth::CreateNotificationChannel(
    grpc::ClientContext& context,
    google::monitoring::v3::CreateNotificationChannelRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateNotificationChannel(context, request);
}

StatusOr<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceAuth::UpdateNotificationChannel(
    grpc::ClientContext& context,
    google::monitoring::v3::UpdateNotificationChannelRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateNotificationChannel(context, request);
}

Status NotificationChannelServiceAuth::DeleteNotificationChannel(
    grpc::ClientContext& context,
    google::monitoring::v3::DeleteNotificationChannelRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteNotificationChannel(context, request);
}

Status NotificationChannelServiceAuth::SendNotificationChannelVerificationCode(
    grpc::ClientContext& context,
    google::monitoring::v3::
        SendNotificationChannelVerificationCodeRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SendNotificationChannelVerificationCode(context, request);
}

StatusOr<google::monitoring::v3::GetNotificationChannelVerificationCodeResponse>
NotificationChannelServiceAuth::GetNotificationChannelVerificationCode(
    grpc::ClientContext& context,
    google::monitoring::v3::GetNotificationChannelVerificationCodeRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetNotificationChannelVerificationCode(context, request);
}

StatusOr<google::monitoring::v3::NotificationChannel>
NotificationChannelServiceAuth::VerifyNotificationChannel(
    grpc::ClientContext& context,
    google::monitoring::v3::VerifyNotificationChannelRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->VerifyNotificationChannel(context, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_internal
}  // namespace cloud
}  // namespace google
