// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/metric_service.proto

#include "google/cloud/monitoring/internal/metric_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/monitoring/v3/metric_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MetricServiceMetadata::MetricServiceMetadata(
    std::shared_ptr<MetricServiceStub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::monitoring::v3::ListMonitoredResourceDescriptorsResponse>
MetricServiceMetadata::ListMonitoredResourceDescriptors(
    grpc::ClientContext& context,
    google::monitoring::v3::ListMonitoredResourceDescriptorsRequest const&
        request) {
  SetMetadata(context, "name=" + request.name());
  return child_->ListMonitoredResourceDescriptors(context, request);
}

StatusOr<google::api::MonitoredResourceDescriptor>
MetricServiceMetadata::GetMonitoredResourceDescriptor(
    grpc::ClientContext& context,
    google::monitoring::v3::GetMonitoredResourceDescriptorRequest const&
        request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetMonitoredResourceDescriptor(context, request);
}

StatusOr<google::monitoring::v3::ListMetricDescriptorsResponse>
MetricServiceMetadata::ListMetricDescriptors(
    grpc::ClientContext& context,
    google::monitoring::v3::ListMetricDescriptorsRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->ListMetricDescriptors(context, request);
}

StatusOr<google::api::MetricDescriptor>
MetricServiceMetadata::GetMetricDescriptor(
    grpc::ClientContext& context,
    google::monitoring::v3::GetMetricDescriptorRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetMetricDescriptor(context, request);
}

StatusOr<google::api::MetricDescriptor>
MetricServiceMetadata::CreateMetricDescriptor(
    grpc::ClientContext& context,
    google::monitoring::v3::CreateMetricDescriptorRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->CreateMetricDescriptor(context, request);
}

Status MetricServiceMetadata::DeleteMetricDescriptor(
    grpc::ClientContext& context,
    google::monitoring::v3::DeleteMetricDescriptorRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->DeleteMetricDescriptor(context, request);
}

StatusOr<google::monitoring::v3::ListTimeSeriesResponse>
MetricServiceMetadata::ListTimeSeries(
    grpc::ClientContext& context,
    google::monitoring::v3::ListTimeSeriesRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->ListTimeSeries(context, request);
}

Status MetricServiceMetadata::CreateTimeSeries(
    grpc::ClientContext& context,
    google::monitoring::v3::CreateTimeSeriesRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->CreateTimeSeries(context, request);
}

Status MetricServiceMetadata::CreateServiceTimeSeries(
    grpc::ClientContext& context,
    google::monitoring::v3::CreateTimeSeriesRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->CreateServiceTimeSeries(context, request);
}

void MetricServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                        std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void MetricServiceMetadata::SetMetadata(grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_internal
}  // namespace cloud
}  // namespace google
