// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/group_service.proto

#include "google/cloud/monitoring/internal/group_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/monitoring/v3/group_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GroupServiceStub::~GroupServiceStub() = default;

StatusOr<google::monitoring::v3::ListGroupsResponse>
DefaultGroupServiceStub::ListGroups(
    grpc::ClientContext& client_context,
    google::monitoring::v3::ListGroupsRequest const& request) {
  google::monitoring::v3::ListGroupsResponse response;
  auto status = grpc_stub_->ListGroups(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::monitoring::v3::Group> DefaultGroupServiceStub::GetGroup(
    grpc::ClientContext& client_context,
    google::monitoring::v3::GetGroupRequest const& request) {
  google::monitoring::v3::Group response;
  auto status = grpc_stub_->GetGroup(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::monitoring::v3::Group> DefaultGroupServiceStub::CreateGroup(
    grpc::ClientContext& client_context,
    google::monitoring::v3::CreateGroupRequest const& request) {
  google::monitoring::v3::Group response;
  auto status = grpc_stub_->CreateGroup(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::monitoring::v3::Group> DefaultGroupServiceStub::UpdateGroup(
    grpc::ClientContext& client_context,
    google::monitoring::v3::UpdateGroupRequest const& request) {
  google::monitoring::v3::Group response;
  auto status = grpc_stub_->UpdateGroup(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultGroupServiceStub::DeleteGroup(
    grpc::ClientContext& client_context,
    google::monitoring::v3::DeleteGroupRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteGroup(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::monitoring::v3::ListGroupMembersResponse>
DefaultGroupServiceStub::ListGroupMembers(
    grpc::ClientContext& client_context,
    google::monitoring::v3::ListGroupMembersRequest const& request) {
  google::monitoring::v3::ListGroupMembersResponse response;
  auto status =
      grpc_stub_->ListGroupMembers(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_internal
}  // namespace cloud
}  // namespace google
