// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/dashboard/v1/dashboards_service.proto

#include "google/cloud/monitoring/internal/dashboards_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/monitoring/dashboard/v1/dashboards_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DashboardsServiceStub::~DashboardsServiceStub() = default;

StatusOr<google::monitoring::dashboard::v1::Dashboard>
DefaultDashboardsServiceStub::CreateDashboard(
    grpc::ClientContext& client_context,
    google::monitoring::dashboard::v1::CreateDashboardRequest const& request) {
  google::monitoring::dashboard::v1::Dashboard response;
  auto status =
      grpc_stub_->CreateDashboard(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::monitoring::dashboard::v1::ListDashboardsResponse>
DefaultDashboardsServiceStub::ListDashboards(
    grpc::ClientContext& client_context,
    google::monitoring::dashboard::v1::ListDashboardsRequest const& request) {
  google::monitoring::dashboard::v1::ListDashboardsResponse response;
  auto status = grpc_stub_->ListDashboards(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::monitoring::dashboard::v1::Dashboard>
DefaultDashboardsServiceStub::GetDashboard(
    grpc::ClientContext& client_context,
    google::monitoring::dashboard::v1::GetDashboardRequest const& request) {
  google::monitoring::dashboard::v1::Dashboard response;
  auto status = grpc_stub_->GetDashboard(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultDashboardsServiceStub::DeleteDashboard(
    grpc::ClientContext& client_context,
    google::monitoring::dashboard::v1::DeleteDashboardRequest const& request) {
  google::protobuf::Empty response;
  auto status =
      grpc_stub_->DeleteDashboard(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::monitoring::dashboard::v1::Dashboard>
DefaultDashboardsServiceStub::UpdateDashboard(
    grpc::ClientContext& client_context,
    google::monitoring::dashboard::v1::UpdateDashboardRequest const& request) {
  google::monitoring::dashboard::v1::Dashboard response;
  auto status =
      grpc_stub_->UpdateDashboard(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_internal
}  // namespace cloud
}  // namespace google
