// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/dashboard/v1/dashboards_service.proto

#include "google/cloud/monitoring/internal/dashboards_connection_impl.h"
#include "google/cloud/monitoring/internal/dashboards_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DashboardsServiceConnectionImpl::DashboardsServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<monitoring_internal::DashboardsServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options),
          monitoring_internal::DashboardsServiceDefaultOptions(
              DashboardsServiceConnection::options()))) {}

StatusOr<google::monitoring::dashboard::v1::Dashboard>
DashboardsServiceConnectionImpl::CreateDashboard(
    google::monitoring::dashboard::v1::CreateDashboardRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateDashboard(request),
      [this](grpc::ClientContext& context,
             google::monitoring::dashboard::v1::CreateDashboardRequest const&
                 request) { return stub_->CreateDashboard(context, request); },
      request, __func__);
}

StreamRange<google::monitoring::dashboard::v1::Dashboard>
DashboardsServiceConnectionImpl::ListDashboards(
    google::monitoring::dashboard::v1::ListDashboardsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<monitoring::DashboardsServiceRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListDashboards(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::monitoring::dashboard::v1::Dashboard>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::monitoring::dashboard::v1::ListDashboardsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::monitoring::dashboard::v1::ListDashboardsRequest const&
                    request) { return stub->ListDashboards(context, request); },
            r, function_name);
      },
      [](google::monitoring::dashboard::v1::ListDashboardsResponse r) {
        std::vector<google::monitoring::dashboard::v1::Dashboard> result(
            r.dashboards().size());
        auto& messages = *r.mutable_dashboards();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::monitoring::dashboard::v1::Dashboard>
DashboardsServiceConnectionImpl::GetDashboard(
    google::monitoring::dashboard::v1::GetDashboardRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetDashboard(request),
      [this](grpc::ClientContext& context,
             google::monitoring::dashboard::v1::GetDashboardRequest const&
                 request) { return stub_->GetDashboard(context, request); },
      request, __func__);
}

Status DashboardsServiceConnectionImpl::DeleteDashboard(
    google::monitoring::dashboard::v1::DeleteDashboardRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteDashboard(request),
      [this](grpc::ClientContext& context,
             google::monitoring::dashboard::v1::DeleteDashboardRequest const&
                 request) { return stub_->DeleteDashboard(context, request); },
      request, __func__);
}

StatusOr<google::monitoring::dashboard::v1::Dashboard>
DashboardsServiceConnectionImpl::UpdateDashboard(
    google::monitoring::dashboard::v1::UpdateDashboardRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateDashboard(request),
      [this](grpc::ClientContext& context,
             google::monitoring::dashboard::v1::UpdateDashboardRequest const&
                 request) { return stub_->UpdateDashboard(context, request); },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_internal
}  // namespace cloud
}  // namespace google
