// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/dashboard/v1/dashboards_service.proto

#include "google/cloud/monitoring/internal/dashboards_auth_decorator.h"
#include <google/monitoring/dashboard/v1/dashboards_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DashboardsServiceAuth::DashboardsServiceAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<DashboardsServiceStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::monitoring::dashboard::v1::Dashboard>
DashboardsServiceAuth::CreateDashboard(
    grpc::ClientContext& context,
    google::monitoring::dashboard::v1::CreateDashboardRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateDashboard(context, request);
}

StatusOr<google::monitoring::dashboard::v1::ListDashboardsResponse>
DashboardsServiceAuth::ListDashboards(
    grpc::ClientContext& context,
    google::monitoring::dashboard::v1::ListDashboardsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListDashboards(context, request);
}

StatusOr<google::monitoring::dashboard::v1::Dashboard>
DashboardsServiceAuth::GetDashboard(
    grpc::ClientContext& context,
    google::monitoring::dashboard::v1::GetDashboardRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetDashboard(context, request);
}

Status DashboardsServiceAuth::DeleteDashboard(
    grpc::ClientContext& context,
    google::monitoring::dashboard::v1::DeleteDashboardRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteDashboard(context, request);
}

StatusOr<google::monitoring::dashboard::v1::Dashboard>
DashboardsServiceAuth::UpdateDashboard(
    grpc::ClientContext& context,
    google::monitoring::dashboard::v1::UpdateDashboardRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateDashboard(context, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_internal
}  // namespace cloud
}  // namespace google
