// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/alert_service.proto

#include "google/cloud/monitoring/internal/alert_policy_connection_impl.h"
#include "google/cloud/monitoring/internal/alert_policy_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AlertPolicyServiceConnectionImpl::AlertPolicyServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<monitoring_internal::AlertPolicyServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options),
          monitoring_internal::AlertPolicyServiceDefaultOptions(
              AlertPolicyServiceConnection::options()))) {}

StreamRange<google::monitoring::v3::AlertPolicy>
AlertPolicyServiceConnectionImpl::ListAlertPolicies(
    google::monitoring::v3::ListAlertPoliciesRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<monitoring::AlertPolicyServiceRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListAlertPolicies(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::monitoring::v3::AlertPolicy>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::monitoring::v3::ListAlertPoliciesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::monitoring::v3::ListAlertPoliciesRequest const&
                       request) {
              return stub->ListAlertPolicies(context, request);
            },
            r, function_name);
      },
      [](google::monitoring::v3::ListAlertPoliciesResponse r) {
        std::vector<google::monitoring::v3::AlertPolicy> result(
            r.alert_policies().size());
        auto& messages = *r.mutable_alert_policies();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::monitoring::v3::AlertPolicy>
AlertPolicyServiceConnectionImpl::GetAlertPolicy(
    google::monitoring::v3::GetAlertPolicyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetAlertPolicy(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::GetAlertPolicyRequest const& request) {
        return stub_->GetAlertPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::monitoring::v3::AlertPolicy>
AlertPolicyServiceConnectionImpl::CreateAlertPolicy(
    google::monitoring::v3::CreateAlertPolicyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateAlertPolicy(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::CreateAlertPolicyRequest const& request) {
        return stub_->CreateAlertPolicy(context, request);
      },
      request, __func__);
}

Status AlertPolicyServiceConnectionImpl::DeleteAlertPolicy(
    google::monitoring::v3::DeleteAlertPolicyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteAlertPolicy(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::DeleteAlertPolicyRequest const& request) {
        return stub_->DeleteAlertPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::monitoring::v3::AlertPolicy>
AlertPolicyServiceConnectionImpl::UpdateAlertPolicy(
    google::monitoring::v3::UpdateAlertPolicyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateAlertPolicy(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::UpdateAlertPolicyRequest const& request) {
        return stub_->UpdateAlertPolicy(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_internal
}  // namespace cloud
}  // namespace google
