// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/group_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_GROUP_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_GROUP_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/internal/retry_policy.h"
#include "google/cloud/version.h"
#include <google/monitoring/v3/group_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace monitoring {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class GroupServiceConnectionIdempotencyPolicy {
 public:
  virtual ~GroupServiceConnectionIdempotencyPolicy() = 0;

  /// Create a new copy of this object.
  virtual std::unique_ptr<GroupServiceConnectionIdempotencyPolicy> clone()
      const = 0;

  virtual google::cloud::Idempotency ListGroups(
      google::monitoring::v3::ListGroupsRequest request) = 0;

  virtual google::cloud::Idempotency GetGroup(
      google::monitoring::v3::GetGroupRequest const& request) = 0;

  virtual google::cloud::Idempotency CreateGroup(
      google::monitoring::v3::CreateGroupRequest const& request) = 0;

  virtual google::cloud::Idempotency UpdateGroup(
      google::monitoring::v3::UpdateGroupRequest const& request) = 0;

  virtual google::cloud::Idempotency DeleteGroup(
      google::monitoring::v3::DeleteGroupRequest const& request) = 0;

  virtual google::cloud::Idempotency ListGroupMembers(
      google::monitoring::v3::ListGroupMembersRequest request) = 0;
};

std::unique_ptr<GroupServiceConnectionIdempotencyPolicy>
MakeDefaultGroupServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_GROUP_CONNECTION_IDEMPOTENCY_POLICY_H
