// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/group_service.proto

#include "google/cloud/monitoring/group_connection.h"
#include "google/cloud/monitoring/group_options.h"
#include "google/cloud/monitoring/internal/group_connection_impl.h"
#include "google/cloud/monitoring/internal/group_option_defaults.h"
#include "google/cloud/monitoring/internal/group_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GroupServiceConnection::~GroupServiceConnection() = default;

StreamRange<google::monitoring::v3::Group> GroupServiceConnection::ListGroups(
    google::monitoring::v3::ListGroupsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::monitoring::v3::Group>>(
      std::move(request),
      [](google::monitoring::v3::ListGroupsRequest const&) {
        return StatusOr<google::monitoring::v3::ListGroupsResponse>{};
      },
      [](google::monitoring::v3::ListGroupsResponse const&) {
        return std::vector<google::monitoring::v3::Group>();
      });
}

StatusOr<google::monitoring::v3::Group> GroupServiceConnection::GetGroup(
    google::monitoring::v3::GetGroupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::monitoring::v3::Group> GroupServiceConnection::CreateGroup(
    google::monitoring::v3::CreateGroupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::monitoring::v3::Group> GroupServiceConnection::UpdateGroup(
    google::monitoring::v3::UpdateGroupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status GroupServiceConnection::DeleteGroup(
    google::monitoring::v3::DeleteGroupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::api::MonitoredResource>
GroupServiceConnection::ListGroupMembers(
    google::monitoring::v3::ListGroupMembersRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::api::MonitoredResource>>(
      std::move(request),
      [](google::monitoring::v3::ListGroupMembersRequest const&) {
        return StatusOr<google::monitoring::v3::ListGroupMembersResponse>{};
      },
      [](google::monitoring::v3::ListGroupMembersResponse const&) {
        return std::vector<google::api::MonitoredResource>();
      });
}

std::shared_ptr<GroupServiceConnection> MakeGroupServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 GroupServicePolicyOptionList>(options,
                                                               __func__);
  options = monitoring_internal::GroupServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = monitoring_internal::CreateDefaultGroupServiceStub(
      background->cq(), options);
  return std::make_shared<monitoring_internal::GroupServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace monitoring_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<monitoring::GroupServiceConnection> MakeGroupServiceConnection(
    std::shared_ptr<GroupServiceStub> stub, Options options) {
  options = GroupServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<monitoring_internal::GroupServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_internal
}  // namespace cloud
}  // namespace google
