// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/dashboard/v1/dashboards_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_DASHBOARDS_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_DASHBOARDS_CONNECTION_H

#include "google/cloud/monitoring/dashboards_connection_idempotency_policy.h"
#include "google/cloud/monitoring/internal/dashboards_retry_traits.h"
#include "google/cloud/monitoring/internal/dashboards_stub.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using DashboardsServiceRetryPolicy =
    ::google::cloud::internal::TraitBasedRetryPolicy<
        monitoring_internal::DashboardsServiceRetryTraits>;

using DashboardsServiceLimitedTimeRetryPolicy =
    ::google::cloud::internal::LimitedTimeRetryPolicy<
        monitoring_internal::DashboardsServiceRetryTraits>;

using DashboardsServiceLimitedErrorCountRetryPolicy =
    ::google::cloud::internal::LimitedErrorCountRetryPolicy<
        monitoring_internal::DashboardsServiceRetryTraits>;

class DashboardsServiceConnection {
 public:
  virtual ~DashboardsServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<google::monitoring::dashboard::v1::Dashboard>
  CreateDashboard(
      google::monitoring::dashboard::v1::CreateDashboardRequest const& request);

  virtual StreamRange<google::monitoring::dashboard::v1::Dashboard>
  ListDashboards(
      google::monitoring::dashboard::v1::ListDashboardsRequest request);

  virtual StatusOr<google::monitoring::dashboard::v1::Dashboard> GetDashboard(
      google::monitoring::dashboard::v1::GetDashboardRequest const& request);

  virtual Status DeleteDashboard(
      google::monitoring::dashboard::v1::DeleteDashboardRequest const& request);

  virtual StatusOr<google::monitoring::dashboard::v1::Dashboard>
  UpdateDashboard(
      google::monitoring::dashboard::v1::UpdateDashboardRequest const& request);
};

std::shared_ptr<DashboardsServiceConnection> MakeDashboardsServiceConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace monitoring_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<monitoring::DashboardsServiceConnection>
MakeDashboardsServiceConnection(std::shared_ptr<DashboardsServiceStub> stub,
                                Options options);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_DASHBOARDS_CONNECTION_H
