// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/dashboard/v1/dashboards_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_DASHBOARDS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_DASHBOARDS_CLIENT_H

#include "google/cloud/monitoring/dashboards_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Manages Stackdriver dashboards. A dashboard is an arrangement of data
/// display widgets in a specific layout.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class DashboardsServiceClient {
 public:
  explicit DashboardsServiceClient(
      std::shared_ptr<DashboardsServiceConnection> connection,
      Options options = {});
  ~DashboardsServiceClient();

  //@{
  // @name Copy and move support
  DashboardsServiceClient(DashboardsServiceClient const&) = default;
  DashboardsServiceClient& operator=(DashboardsServiceClient const&) = default;
  DashboardsServiceClient(DashboardsServiceClient&&) = default;
  DashboardsServiceClient& operator=(DashboardsServiceClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(DashboardsServiceClient const& a,
                         DashboardsServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(DashboardsServiceClient const& a,
                         DashboardsServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Creates a new custom dashboard. For examples on how you can use this API
  /// to create dashboards, see [Managing dashboards by
  /// API](https://cloud.google.com/monitoring/dashboards/api-dashboard). This
  /// method requires the `monitoring.dashboards.create` permission on the
  /// specified project. For more information about permissions, see [Cloud
  /// Identity and Access Management](https://cloud.google.com/iam).
  ///
  /// @param request
  /// @googleapis_link{google::monitoring::dashboard::v1::CreateDashboardRequest,google/monitoring/dashboard/v1/dashboards_service.proto#L101}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::monitoring::dashboard::v1::Dashboard,google/monitoring/dashboard/v1/dashboard.proto#L33}
  ///
  /// [google.monitoring.dashboard.v1.CreateDashboardRequest]:
  /// @googleapis_reference_link{google/monitoring/dashboard/v1/dashboards_service.proto#L101}
  /// [google.monitoring.dashboard.v1.Dashboard]:
  /// @googleapis_reference_link{google/monitoring/dashboard/v1/dashboard.proto#L33}
  ///
  StatusOr<google::monitoring::dashboard::v1::Dashboard> CreateDashboard(
      google::monitoring::dashboard::v1::CreateDashboardRequest const& request,
      Options options = {});

  ///
  /// Lists the existing dashboards.
  ///
  /// This method requires the `monitoring.dashboards.list` permission
  /// on the specified project. For more information, see
  /// [Cloud Identity and Access Management](https://cloud.google.com/iam).
  ///
  /// @param request
  /// @googleapis_link{google::monitoring::dashboard::v1::ListDashboardsRequest,google/monitoring/dashboard/v1/dashboards_service.proto#L118}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::monitoring::dashboard::v1::Dashboard,google/monitoring/dashboard/v1/dashboard.proto#L33}
  ///
  /// [google.monitoring.dashboard.v1.ListDashboardsRequest]:
  /// @googleapis_reference_link{google/monitoring/dashboard/v1/dashboards_service.proto#L118}
  /// [google.monitoring.dashboard.v1.Dashboard]:
  /// @googleapis_reference_link{google/monitoring/dashboard/v1/dashboard.proto#L33}
  ///
  StreamRange<google::monitoring::dashboard::v1::Dashboard> ListDashboards(
      google::monitoring::dashboard::v1::ListDashboardsRequest request,
      Options options = {});

  ///
  /// Fetches a specific dashboard.
  ///
  /// This method requires the `monitoring.dashboards.get` permission
  /// on the specified dashboard. For more information, see
  /// [Cloud Identity and Access Management](https://cloud.google.com/iam).
  ///
  /// @param request
  /// @googleapis_link{google::monitoring::dashboard::v1::GetDashboardRequest,google/monitoring/dashboard/v1/dashboards_service.proto#L151}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::monitoring::dashboard::v1::Dashboard,google/monitoring/dashboard/v1/dashboard.proto#L33}
  ///
  /// [google.monitoring.dashboard.v1.GetDashboardRequest]:
  /// @googleapis_reference_link{google/monitoring/dashboard/v1/dashboards_service.proto#L151}
  /// [google.monitoring.dashboard.v1.Dashboard]:
  /// @googleapis_reference_link{google/monitoring/dashboard/v1/dashboard.proto#L33}
  ///
  StatusOr<google::monitoring::dashboard::v1::Dashboard> GetDashboard(
      google::monitoring::dashboard::v1::GetDashboardRequest const& request,
      Options options = {});

  ///
  /// Deletes an existing custom dashboard.
  ///
  /// This method requires the `monitoring.dashboards.delete` permission
  /// on the specified dashboard. For more information, see
  /// [Cloud Identity and Access Management](https://cloud.google.com/iam).
  ///
  /// @param request
  /// @googleapis_link{google::monitoring::dashboard::v1::DeleteDashboardRequest,google/monitoring/dashboard/v1/dashboards_service.proto#L166}
  /// @param options  Optional. Operation options.
  ///
  /// [google.monitoring.dashboard.v1.DeleteDashboardRequest]:
  /// @googleapis_reference_link{google/monitoring/dashboard/v1/dashboards_service.proto#L166}
  ///
  Status DeleteDashboard(
      google::monitoring::dashboard::v1::DeleteDashboardRequest const& request,
      Options options = {});

  ///
  /// Replaces an existing custom dashboard with a new definition.
  ///
  /// This method requires the `monitoring.dashboards.update` permission
  /// on the specified dashboard. For more information, see
  /// [Cloud Identity and Access Management](https://cloud.google.com/iam).
  ///
  /// @param request
  /// @googleapis_link{google::monitoring::dashboard::v1::UpdateDashboardRequest,google/monitoring/dashboard/v1/dashboards_service.proto#L179}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::monitoring::dashboard::v1::Dashboard,google/monitoring/dashboard/v1/dashboard.proto#L33}
  ///
  /// [google.monitoring.dashboard.v1.UpdateDashboardRequest]:
  /// @googleapis_reference_link{google/monitoring/dashboard/v1/dashboards_service.proto#L179}
  /// [google.monitoring.dashboard.v1.Dashboard]:
  /// @googleapis_reference_link{google/monitoring/dashboard/v1/dashboard.proto#L33}
  ///
  StatusOr<google::monitoring::dashboard::v1::Dashboard> UpdateDashboard(
      google::monitoring::dashboard::v1::UpdateDashboardRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<DashboardsServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_DASHBOARDS_CLIENT_H
