// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/memcache/v1/cloud_memcache.proto

#include "google/cloud/memcache/cloud_memcache_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace memcache {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

CloudMemcacheConnectionIdempotencyPolicy::
    ~CloudMemcacheConnectionIdempotencyPolicy() = default;

namespace {
class DefaultCloudMemcacheConnectionIdempotencyPolicy
    : public CloudMemcacheConnectionIdempotencyPolicy {
 public:
  ~DefaultCloudMemcacheConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<CloudMemcacheConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultCloudMemcacheConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency ListInstances(
      google::cloud::memcache::v1::ListInstancesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetInstance(
      google::cloud::memcache::v1::GetInstanceRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateInstance(
      google::cloud::memcache::v1::CreateInstanceRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateInstance(
      google::cloud::memcache::v1::UpdateInstanceRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateParameters(
      google::cloud::memcache::v1::UpdateParametersRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteInstance(
      google::cloud::memcache::v1::DeleteInstanceRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ApplyParameters(
      google::cloud::memcache::v1::ApplyParametersRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<CloudMemcacheConnectionIdempotencyPolicy>
MakeDefaultCloudMemcacheConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultCloudMemcacheConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace memcache
}  // namespace cloud
}  // namespace google
