// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/memcache/v1/cloud_memcache.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MEMCACHE_CLOUD_MEMCACHE_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MEMCACHE_CLOUD_MEMCACHE_CONNECTION_H

#include "google/cloud/memcache/cloud_memcache_connection_idempotency_policy.h"
#include "google/cloud/memcache/internal/cloud_memcache_retry_traits.h"
#include "google/cloud/memcache/internal/cloud_memcache_stub.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace memcache {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using CloudMemcacheRetryPolicy =
    ::google::cloud::internal::TraitBasedRetryPolicy<
        memcache_internal::CloudMemcacheRetryTraits>;

using CloudMemcacheLimitedTimeRetryPolicy =
    ::google::cloud::internal::LimitedTimeRetryPolicy<
        memcache_internal::CloudMemcacheRetryTraits>;

using CloudMemcacheLimitedErrorCountRetryPolicy =
    ::google::cloud::internal::LimitedErrorCountRetryPolicy<
        memcache_internal::CloudMemcacheRetryTraits>;

class CloudMemcacheConnection {
 public:
  virtual ~CloudMemcacheConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StreamRange<google::cloud::memcache::v1::Instance> ListInstances(
      google::cloud::memcache::v1::ListInstancesRequest request);

  virtual StatusOr<google::cloud::memcache::v1::Instance> GetInstance(
      google::cloud::memcache::v1::GetInstanceRequest const& request);

  virtual future<StatusOr<google::cloud::memcache::v1::Instance>>
  CreateInstance(
      google::cloud::memcache::v1::CreateInstanceRequest const& request);

  virtual future<StatusOr<google::cloud::memcache::v1::Instance>>
  UpdateInstance(
      google::cloud::memcache::v1::UpdateInstanceRequest const& request);

  virtual future<StatusOr<google::cloud::memcache::v1::Instance>>
  UpdateParameters(
      google::cloud::memcache::v1::UpdateParametersRequest const& request);

  virtual future<StatusOr<google::cloud::memcache::v1::OperationMetadata>>
  DeleteInstance(
      google::cloud::memcache::v1::DeleteInstanceRequest const& request);

  virtual future<StatusOr<google::cloud::memcache::v1::Instance>>
  ApplyParameters(
      google::cloud::memcache::v1::ApplyParametersRequest const& request);
};

std::shared_ptr<CloudMemcacheConnection> MakeCloudMemcacheConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace memcache
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace memcache_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<memcache::CloudMemcacheConnection> MakeCloudMemcacheConnection(
    std::shared_ptr<CloudMemcacheStub> stub, Options options);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace memcache_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MEMCACHE_CLOUD_MEMCACHE_CONNECTION_H
