// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/memcache/v1/cloud_memcache.proto

#include "google/cloud/memcache/cloud_memcache_client.h"
#include "google/cloud/memcache/internal/cloud_memcache_option_defaults.h"
#include <memory>

namespace google {
namespace cloud {
namespace memcache {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudMemcacheClient::CloudMemcacheClient(
    std::shared_ptr<CloudMemcacheConnection> connection, Options options)
    : connection_(std::move(connection)),
      options_(internal::MergeOptions(
          std::move(options), memcache_internal::CloudMemcacheDefaultOptions(
                                  connection_->options()))) {}
CloudMemcacheClient::~CloudMemcacheClient() = default;

StreamRange<google::cloud::memcache::v1::Instance>
CloudMemcacheClient::ListInstances(std::string const& parent, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::memcache::v1::ListInstancesRequest request;
  request.set_parent(parent);
  return connection_->ListInstances(request);
}

StreamRange<google::cloud::memcache::v1::Instance>
CloudMemcacheClient::ListInstances(
    google::cloud::memcache::v1::ListInstancesRequest request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListInstances(std::move(request));
}

StatusOr<google::cloud::memcache::v1::Instance>
CloudMemcacheClient::GetInstance(std::string const& name, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::memcache::v1::GetInstanceRequest request;
  request.set_name(name);
  return connection_->GetInstance(request);
}

StatusOr<google::cloud::memcache::v1::Instance>
CloudMemcacheClient::GetInstance(
    google::cloud::memcache::v1::GetInstanceRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetInstance(request);
}

future<StatusOr<google::cloud::memcache::v1::Instance>>
CloudMemcacheClient::CreateInstance(
    std::string const& parent,
    google::cloud::memcache::v1::Instance const& instance,
    std::string const& instance_id, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::memcache::v1::CreateInstanceRequest request;
  request.set_parent(parent);
  *request.mutable_instance() = instance;
  request.set_instance_id(instance_id);
  return connection_->CreateInstance(request);
}

future<StatusOr<google::cloud::memcache::v1::Instance>>
CloudMemcacheClient::CreateInstance(
    google::cloud::memcache::v1::CreateInstanceRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CreateInstance(request);
}

future<StatusOr<google::cloud::memcache::v1::Instance>>
CloudMemcacheClient::UpdateInstance(
    google::cloud::memcache::v1::Instance const& instance,
    google::protobuf::FieldMask const& update_mask, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::memcache::v1::UpdateInstanceRequest request;
  *request.mutable_instance() = instance;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateInstance(request);
}

future<StatusOr<google::cloud::memcache::v1::Instance>>
CloudMemcacheClient::UpdateInstance(
    google::cloud::memcache::v1::UpdateInstanceRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdateInstance(request);
}

future<StatusOr<google::cloud::memcache::v1::Instance>>
CloudMemcacheClient::UpdateParameters(
    std::string const& name, google::protobuf::FieldMask const& update_mask,
    google::cloud::memcache::v1::MemcacheParameters const& parameters,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::memcache::v1::UpdateParametersRequest request;
  request.set_name(name);
  *request.mutable_update_mask() = update_mask;
  *request.mutable_parameters() = parameters;
  return connection_->UpdateParameters(request);
}

future<StatusOr<google::cloud::memcache::v1::Instance>>
CloudMemcacheClient::UpdateParameters(
    google::cloud::memcache::v1::UpdateParametersRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdateParameters(request);
}

future<StatusOr<google::cloud::memcache::v1::OperationMetadata>>
CloudMemcacheClient::DeleteInstance(std::string const& name, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::memcache::v1::DeleteInstanceRequest request;
  request.set_name(name);
  return connection_->DeleteInstance(request);
}

future<StatusOr<google::cloud::memcache::v1::OperationMetadata>>
CloudMemcacheClient::DeleteInstance(
    google::cloud::memcache::v1::DeleteInstanceRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeleteInstance(request);
}

future<StatusOr<google::cloud::memcache::v1::Instance>>
CloudMemcacheClient::ApplyParameters(std::string const& name,
                                     std::vector<std::string> const& node_ids,
                                     bool apply_all, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::memcache::v1::ApplyParametersRequest request;
  request.set_name(name);
  *request.mutable_node_ids() = {node_ids.begin(), node_ids.end()};
  request.set_apply_all(apply_all);
  return connection_->ApplyParameters(request);
}

future<StatusOr<google::cloud::memcache::v1::Instance>>
CloudMemcacheClient::ApplyParameters(
    google::cloud::memcache::v1::ApplyParametersRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ApplyParameters(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace memcache
}  // namespace cloud
}  // namespace google
