// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/logging/v2/logging.proto

#include "google/cloud/logging/logging_service_v2_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace logging {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

LoggingServiceV2ConnectionIdempotencyPolicy::
    ~LoggingServiceV2ConnectionIdempotencyPolicy() = default;

namespace {
class DefaultLoggingServiceV2ConnectionIdempotencyPolicy
    : public LoggingServiceV2ConnectionIdempotencyPolicy {
 public:
  ~DefaultLoggingServiceV2ConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<LoggingServiceV2ConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<
        DefaultLoggingServiceV2ConnectionIdempotencyPolicy>(*this);
  }

  Idempotency DeleteLog(google::logging::v2::DeleteLogRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency WriteLogEntries(
      google::logging::v2::WriteLogEntriesRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListLogEntries(
      google::logging::v2::ListLogEntriesRequest) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListMonitoredResourceDescriptors(
      google::logging::v2::ListMonitoredResourceDescriptorsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListLogs(google::logging::v2::ListLogsRequest) override {
    return Idempotency::kIdempotent;
  }
};
}  // namespace

std::unique_ptr<LoggingServiceV2ConnectionIdempotencyPolicy>
MakeDefaultLoggingServiceV2ConnectionIdempotencyPolicy() {
  return absl::make_unique<
      DefaultLoggingServiceV2ConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace logging
}  // namespace cloud
}  // namespace google
