// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/kms/v1/service.proto

#include "google/cloud/kms/key_management_connection.h"
#include "google/cloud/kms/internal/key_management_connection_impl.h"
#include "google/cloud/kms/internal/key_management_option_defaults.h"
#include "google/cloud/kms/internal/key_management_stub_factory.h"
#include "google/cloud/kms/key_management_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace kms {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

KeyManagementServiceConnection::~KeyManagementServiceConnection() = default;

StreamRange<google::cloud::kms::v1::KeyRing>
KeyManagementServiceConnection::ListKeyRings(
    google::cloud::kms::v1::ListKeyRingsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::kms::v1::KeyRing>>(
      std::move(request),
      [](google::cloud::kms::v1::ListKeyRingsRequest const&) {
        return StatusOr<google::cloud::kms::v1::ListKeyRingsResponse>{};
      },
      [](google::cloud::kms::v1::ListKeyRingsResponse const&) {
        return std::vector<google::cloud::kms::v1::KeyRing>();
      });
}

StreamRange<google::cloud::kms::v1::CryptoKey>
KeyManagementServiceConnection::ListCryptoKeys(
    google::cloud::kms::v1::ListCryptoKeysRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::kms::v1::CryptoKey>>(
      std::move(request),
      [](google::cloud::kms::v1::ListCryptoKeysRequest const&) {
        return StatusOr<google::cloud::kms::v1::ListCryptoKeysResponse>{};
      },
      [](google::cloud::kms::v1::ListCryptoKeysResponse const&) {
        return std::vector<google::cloud::kms::v1::CryptoKey>();
      });
}

StreamRange<google::cloud::kms::v1::CryptoKeyVersion>
KeyManagementServiceConnection::ListCryptoKeyVersions(
    google::cloud::kms::v1::ListCryptoKeyVersionsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::kms::v1::CryptoKeyVersion>>(
      std::move(request),
      [](google::cloud::kms::v1::ListCryptoKeyVersionsRequest const&) {
        return StatusOr<
            google::cloud::kms::v1::ListCryptoKeyVersionsResponse>{};
      },
      [](google::cloud::kms::v1::ListCryptoKeyVersionsResponse const&) {
        return std::vector<google::cloud::kms::v1::CryptoKeyVersion>();
      });
}

StreamRange<google::cloud::kms::v1::ImportJob>
KeyManagementServiceConnection::ListImportJobs(
    google::cloud::kms::v1::ListImportJobsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::kms::v1::ImportJob>>(
      std::move(request),
      [](google::cloud::kms::v1::ListImportJobsRequest const&) {
        return StatusOr<google::cloud::kms::v1::ListImportJobsResponse>{};
      },
      [](google::cloud::kms::v1::ListImportJobsResponse const&) {
        return std::vector<google::cloud::kms::v1::ImportJob>();
      });
}

StatusOr<google::cloud::kms::v1::KeyRing>
KeyManagementServiceConnection::GetKeyRing(
    google::cloud::kms::v1::GetKeyRingRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::CryptoKey>
KeyManagementServiceConnection::GetCryptoKey(
    google::cloud::kms::v1::GetCryptoKeyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::CryptoKeyVersion>
KeyManagementServiceConnection::GetCryptoKeyVersion(
    google::cloud::kms::v1::GetCryptoKeyVersionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::PublicKey>
KeyManagementServiceConnection::GetPublicKey(
    google::cloud::kms::v1::GetPublicKeyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::ImportJob>
KeyManagementServiceConnection::GetImportJob(
    google::cloud::kms::v1::GetImportJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::KeyRing>
KeyManagementServiceConnection::CreateKeyRing(
    google::cloud::kms::v1::CreateKeyRingRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::CryptoKey>
KeyManagementServiceConnection::CreateCryptoKey(
    google::cloud::kms::v1::CreateCryptoKeyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::CryptoKeyVersion>
KeyManagementServiceConnection::CreateCryptoKeyVersion(
    google::cloud::kms::v1::CreateCryptoKeyVersionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::CryptoKeyVersion>
KeyManagementServiceConnection::ImportCryptoKeyVersion(
    google::cloud::kms::v1::ImportCryptoKeyVersionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::ImportJob>
KeyManagementServiceConnection::CreateImportJob(
    google::cloud::kms::v1::CreateImportJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::CryptoKey>
KeyManagementServiceConnection::UpdateCryptoKey(
    google::cloud::kms::v1::UpdateCryptoKeyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::CryptoKeyVersion>
KeyManagementServiceConnection::UpdateCryptoKeyVersion(
    google::cloud::kms::v1::UpdateCryptoKeyVersionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::CryptoKey>
KeyManagementServiceConnection::UpdateCryptoKeyPrimaryVersion(
    google::cloud::kms::v1::UpdateCryptoKeyPrimaryVersionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::CryptoKeyVersion>
KeyManagementServiceConnection::DestroyCryptoKeyVersion(
    google::cloud::kms::v1::DestroyCryptoKeyVersionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::CryptoKeyVersion>
KeyManagementServiceConnection::RestoreCryptoKeyVersion(
    google::cloud::kms::v1::RestoreCryptoKeyVersionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::EncryptResponse>
KeyManagementServiceConnection::Encrypt(
    google::cloud::kms::v1::EncryptRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::DecryptResponse>
KeyManagementServiceConnection::Decrypt(
    google::cloud::kms::v1::DecryptRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::AsymmetricSignResponse>
KeyManagementServiceConnection::AsymmetricSign(
    google::cloud::kms::v1::AsymmetricSignRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::AsymmetricDecryptResponse>
KeyManagementServiceConnection::AsymmetricDecrypt(
    google::cloud::kms::v1::AsymmetricDecryptRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::MacSignResponse>
KeyManagementServiceConnection::MacSign(
    google::cloud::kms::v1::MacSignRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::MacVerifyResponse>
KeyManagementServiceConnection::MacVerify(
    google::cloud::kms::v1::MacVerifyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::kms::v1::GenerateRandomBytesResponse>
KeyManagementServiceConnection::GenerateRandomBytes(
    google::cloud::kms::v1::GenerateRandomBytesRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<KeyManagementServiceConnection>
MakeKeyManagementServiceConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 KeyManagementServicePolicyOptionList>(
      options, __func__);
  options =
      kms_internal::KeyManagementServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = kms_internal::CreateDefaultKeyManagementServiceStub(
      background->cq(), options);
  return std::make_shared<kms_internal::KeyManagementServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace kms
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace kms_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<kms::KeyManagementServiceConnection>
MakeKeyManagementServiceConnection(
    std::shared_ptr<KeyManagementServiceStub> stub, Options options) {
  options = KeyManagementServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<kms_internal::KeyManagementServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace kms_internal
}  // namespace cloud
}  // namespace google
