// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/kms/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_KMS_KEY_MANAGEMENT_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_KMS_KEY_MANAGEMENT_CLIENT_H

#include "google/cloud/kms/key_management_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace kms {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Google Cloud Key Management Service
///
/// Manages cryptographic keys and operations using those keys. Implements a
/// REST model with the following objects:
///
/// * [KeyRing][google.cloud.kms.v1.KeyRing]
/// * [CryptoKey][google.cloud.kms.v1.CryptoKey]
/// * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
/// * [ImportJob][google.cloud.kms.v1.ImportJob]
///
/// If you are using manual gRPC libraries, see
/// [Using gRPC with Cloud KMS](https://cloud.google.com/kms/docs/grpc).
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class KeyManagementServiceClient {
 public:
  explicit KeyManagementServiceClient(
      std::shared_ptr<KeyManagementServiceConnection> connection,
      Options options = {});
  ~KeyManagementServiceClient();

  //@{
  // @name Copy and move support
  KeyManagementServiceClient(KeyManagementServiceClient const&) = default;
  KeyManagementServiceClient& operator=(KeyManagementServiceClient const&) =
      default;
  KeyManagementServiceClient(KeyManagementServiceClient&&) = default;
  KeyManagementServiceClient& operator=(KeyManagementServiceClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(KeyManagementServiceClient const& a,
                         KeyManagementServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(KeyManagementServiceClient const& a,
                         KeyManagementServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Lists [KeyRings][google.cloud.kms.v1.KeyRing].
  ///
  /// @param parent  Required. The resource name of the location associated with
  /// the
  ///  [KeyRings][google.cloud.kms.v1.KeyRing], in the format
  ///  `projects/*/locations/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::KeyRing,google/cloud/kms/v1/resources.proto#L35}
  ///
  /// [google.cloud.kms.v1.ListKeyRingsRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L337}
  /// [google.cloud.kms.v1.KeyRing]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L35}
  ///
  StreamRange<google::cloud::kms::v1::KeyRing> ListKeyRings(
      std::string const& parent, Options options = {});

  ///
  /// Lists [KeyRings][google.cloud.kms.v1.KeyRing].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::ListKeyRingsRequest,google/cloud/kms/v1/service.proto#L337}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::KeyRing,google/cloud/kms/v1/resources.proto#L35}
  ///
  /// [google.cloud.kms.v1.ListKeyRingsRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L337}
  /// [google.cloud.kms.v1.KeyRing]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L35}
  ///
  StreamRange<google::cloud::kms::v1::KeyRing> ListKeyRings(
      google::cloud::kms::v1::ListKeyRingsRequest request,
      Options options = {});

  ///
  /// Lists [CryptoKeys][google.cloud.kms.v1.CryptoKey].
  ///
  /// @param parent  Required. The resource name of the
  /// [KeyRing][google.cloud.kms.v1.KeyRing] to list, in the format
  ///  `projects/*/locations/*/keyRings/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKey,google/cloud/kms/v1/resources.proto#L54}
  ///
  /// [google.cloud.kms.v1.ListCryptoKeysRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L371}
  /// [google.cloud.kms.v1.CryptoKey]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L54}
  ///
  StreamRange<google::cloud::kms::v1::CryptoKey> ListCryptoKeys(
      std::string const& parent, Options options = {});

  ///
  /// Lists [CryptoKeys][google.cloud.kms.v1.CryptoKey].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::ListCryptoKeysRequest,google/cloud/kms/v1/service.proto#L371}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKey,google/cloud/kms/v1/resources.proto#L54}
  ///
  /// [google.cloud.kms.v1.ListCryptoKeysRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L371}
  /// [google.cloud.kms.v1.CryptoKey]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L54}
  ///
  StreamRange<google::cloud::kms::v1::CryptoKey> ListCryptoKeys(
      google::cloud::kms::v1::ListCryptoKeysRequest request,
      Options options = {});

  ///
  /// Lists [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion].
  ///
  /// @param parent  Required. The resource name of the
  /// [CryptoKey][google.cloud.kms.v1.CryptoKey] to list, in the format
  ///  `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKeyVersion,google/cloud/kms/v1/resources.proto#L214}
  ///
  /// [google.cloud.kms.v1.ListCryptoKeyVersionsRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L408}
  /// [google.cloud.kms.v1.CryptoKeyVersion]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L214}
  ///
  StreamRange<google::cloud::kms::v1::CryptoKeyVersion> ListCryptoKeyVersions(
      std::string const& parent, Options options = {});

  ///
  /// Lists [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::ListCryptoKeyVersionsRequest,google/cloud/kms/v1/service.proto#L408}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKeyVersion,google/cloud/kms/v1/resources.proto#L214}
  ///
  /// [google.cloud.kms.v1.ListCryptoKeyVersionsRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L408}
  /// [google.cloud.kms.v1.CryptoKeyVersion]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L214}
  ///
  StreamRange<google::cloud::kms::v1::CryptoKeyVersion> ListCryptoKeyVersions(
      google::cloud::kms::v1::ListCryptoKeyVersionsRequest request,
      Options options = {});

  ///
  /// Lists [ImportJobs][google.cloud.kms.v1.ImportJob].
  ///
  /// @param parent  Required. The resource name of the
  /// [KeyRing][google.cloud.kms.v1.KeyRing] to list, in the format
  ///  `projects/*/locations/*/keyRings/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::ImportJob,google/cloud/kms/v1/resources.proto#L528}
  ///
  /// [google.cloud.kms.v1.ListImportJobsRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L446}
  /// [google.cloud.kms.v1.ImportJob]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L528}
  ///
  StreamRange<google::cloud::kms::v1::ImportJob> ListImportJobs(
      std::string const& parent, Options options = {});

  ///
  /// Lists [ImportJobs][google.cloud.kms.v1.ImportJob].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::ListImportJobsRequest,google/cloud/kms/v1/service.proto#L446}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::ImportJob,google/cloud/kms/v1/resources.proto#L528}
  ///
  /// [google.cloud.kms.v1.ListImportJobsRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L446}
  /// [google.cloud.kms.v1.ImportJob]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L528}
  ///
  StreamRange<google::cloud::kms::v1::ImportJob> ListImportJobs(
      google::cloud::kms::v1::ListImportJobsRequest request,
      Options options = {});

  ///
  /// Returns metadata for a given [KeyRing][google.cloud.kms.v1.KeyRing].
  ///
  /// @param name  Required. The [name][google.cloud.kms.v1.KeyRing.name] of the
  /// [KeyRing][google.cloud.kms.v1.KeyRing] to get.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::KeyRing,google/cloud/kms/v1/resources.proto#L35}
  ///
  /// [google.cloud.kms.v1.GetKeyRingRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L534}
  /// [google.cloud.kms.v1.KeyRing]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L35}
  ///
  StatusOr<google::cloud::kms::v1::KeyRing> GetKeyRing(std::string const& name,
                                                       Options options = {});

  ///
  /// Returns metadata for a given [KeyRing][google.cloud.kms.v1.KeyRing].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::GetKeyRingRequest,google/cloud/kms/v1/service.proto#L534}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::KeyRing,google/cloud/kms/v1/resources.proto#L35}
  ///
  /// [google.cloud.kms.v1.GetKeyRingRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L534}
  /// [google.cloud.kms.v1.KeyRing]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L35}
  ///
  StatusOr<google::cloud::kms::v1::KeyRing> GetKeyRing(
      google::cloud::kms::v1::GetKeyRingRequest const& request,
      Options options = {});

  ///
  /// Returns metadata for a given [CryptoKey][google.cloud.kms.v1.CryptoKey],
  /// as well as its [primary][google.cloud.kms.v1.CryptoKey.primary]
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
  ///
  /// @param name  Required. The [name][google.cloud.kms.v1.CryptoKey.name] of
  /// the [CryptoKey][google.cloud.kms.v1.CryptoKey] to get.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKey,google/cloud/kms/v1/resources.proto#L54}
  ///
  /// [google.cloud.kms.v1.GetCryptoKeyRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L545}
  /// [google.cloud.kms.v1.CryptoKey]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L54}
  ///
  StatusOr<google::cloud::kms::v1::CryptoKey> GetCryptoKey(
      std::string const& name, Options options = {});

  ///
  /// Returns metadata for a given [CryptoKey][google.cloud.kms.v1.CryptoKey],
  /// as well as its [primary][google.cloud.kms.v1.CryptoKey.primary]
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::GetCryptoKeyRequest,google/cloud/kms/v1/service.proto#L545}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKey,google/cloud/kms/v1/resources.proto#L54}
  ///
  /// [google.cloud.kms.v1.GetCryptoKeyRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L545}
  /// [google.cloud.kms.v1.CryptoKey]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L54}
  ///
  StatusOr<google::cloud::kms::v1::CryptoKey> GetCryptoKey(
      google::cloud::kms::v1::GetCryptoKeyRequest const& request,
      Options options = {});

  ///
  /// Returns metadata for a given
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
  ///
  /// @param name  Required. The
  /// [name][google.cloud.kms.v1.CryptoKeyVersion.name] of the
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to get.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKeyVersion,google/cloud/kms/v1/resources.proto#L214}
  ///
  /// [google.cloud.kms.v1.GetCryptoKeyVersionRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L556}
  /// [google.cloud.kms.v1.CryptoKeyVersion]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L214}
  ///
  StatusOr<google::cloud::kms::v1::CryptoKeyVersion> GetCryptoKeyVersion(
      std::string const& name, Options options = {});

  ///
  /// Returns metadata for a given
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::GetCryptoKeyVersionRequest,google/cloud/kms/v1/service.proto#L556}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKeyVersion,google/cloud/kms/v1/resources.proto#L214}
  ///
  /// [google.cloud.kms.v1.GetCryptoKeyVersionRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L556}
  /// [google.cloud.kms.v1.CryptoKeyVersion]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L214}
  ///
  StatusOr<google::cloud::kms::v1::CryptoKeyVersion> GetCryptoKeyVersion(
      google::cloud::kms::v1::GetCryptoKeyVersionRequest const& request,
      Options options = {});

  ///
  /// Returns the public key for the given
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. The
  /// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
  /// [ASYMMETRIC_SIGN][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_SIGN]
  /// or
  /// [ASYMMETRIC_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_DECRYPT].
  ///
  /// @param name  Required. The
  /// [name][google.cloud.kms.v1.CryptoKeyVersion.name] of the
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] public key to
  ///  get.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::PublicKey,google/cloud/kms/v1/resources.proto#L459}
  ///
  /// [google.cloud.kms.v1.GetPublicKeyRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L567}
  /// [google.cloud.kms.v1.PublicKey]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L459}
  ///
  StatusOr<google::cloud::kms::v1::PublicKey> GetPublicKey(
      std::string const& name, Options options = {});

  ///
  /// Returns the public key for the given
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. The
  /// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
  /// [ASYMMETRIC_SIGN][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_SIGN]
  /// or
  /// [ASYMMETRIC_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_DECRYPT].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::GetPublicKeyRequest,google/cloud/kms/v1/service.proto#L567}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::PublicKey,google/cloud/kms/v1/resources.proto#L459}
  ///
  /// [google.cloud.kms.v1.GetPublicKeyRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L567}
  /// [google.cloud.kms.v1.PublicKey]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L459}
  ///
  StatusOr<google::cloud::kms::v1::PublicKey> GetPublicKey(
      google::cloud::kms::v1::GetPublicKeyRequest const& request,
      Options options = {});

  ///
  /// Returns metadata for a given [ImportJob][google.cloud.kms.v1.ImportJob].
  ///
  /// @param name  Required. The [name][google.cloud.kms.v1.ImportJob.name] of
  /// the [ImportJob][google.cloud.kms.v1.ImportJob] to get.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::ImportJob,google/cloud/kms/v1/resources.proto#L528}
  ///
  /// [google.cloud.kms.v1.GetImportJobRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L579}
  /// [google.cloud.kms.v1.ImportJob]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L528}
  ///
  StatusOr<google::cloud::kms::v1::ImportJob> GetImportJob(
      std::string const& name, Options options = {});

  ///
  /// Returns metadata for a given [ImportJob][google.cloud.kms.v1.ImportJob].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::GetImportJobRequest,google/cloud/kms/v1/service.proto#L579}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::ImportJob,google/cloud/kms/v1/resources.proto#L528}
  ///
  /// [google.cloud.kms.v1.GetImportJobRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L579}
  /// [google.cloud.kms.v1.ImportJob]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L528}
  ///
  StatusOr<google::cloud::kms::v1::ImportJob> GetImportJob(
      google::cloud::kms::v1::GetImportJobRequest const& request,
      Options options = {});

  ///
  /// Create a new [KeyRing][google.cloud.kms.v1.KeyRing] in a given Project and
  /// Location.
  ///
  /// @param parent  Required. The resource name of the location associated with
  /// the
  ///  [KeyRings][google.cloud.kms.v1.KeyRing], in the format
  ///  `projects/*/locations/*`.
  /// @param key_ring_id  Required. It must be unique within a location and
  /// match the regular
  ///  expression `[a-zA-Z0-9_-]{1,63}`
  /// @param key_ring  Required. A [KeyRing][google.cloud.kms.v1.KeyRing] with
  /// initial field values.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::KeyRing,google/cloud/kms/v1/resources.proto#L35}
  ///
  /// [google.cloud.kms.v1.CreateKeyRingRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L590}
  /// [google.cloud.kms.v1.KeyRing]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L35}
  ///
  StatusOr<google::cloud::kms::v1::KeyRing> CreateKeyRing(
      std::string const& parent, std::string const& key_ring_id,
      google::cloud::kms::v1::KeyRing const& key_ring, Options options = {});

  ///
  /// Create a new [KeyRing][google.cloud.kms.v1.KeyRing] in a given Project and
  /// Location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::CreateKeyRingRequest,google/cloud/kms/v1/service.proto#L590}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::KeyRing,google/cloud/kms/v1/resources.proto#L35}
  ///
  /// [google.cloud.kms.v1.CreateKeyRingRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L590}
  /// [google.cloud.kms.v1.KeyRing]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L35}
  ///
  StatusOr<google::cloud::kms::v1::KeyRing> CreateKeyRing(
      google::cloud::kms::v1::CreateKeyRingRequest const& request,
      Options options = {});

  ///
  /// Create a new [CryptoKey][google.cloud.kms.v1.CryptoKey] within a
  /// [KeyRing][google.cloud.kms.v1.KeyRing].
  ///
  /// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] and
  /// [CryptoKey.version_template.algorithm][google.cloud.kms.v1.CryptoKeyVersionTemplate.algorithm]
  /// are required.
  ///
  /// @param parent  Required. The [name][google.cloud.kms.v1.KeyRing.name] of
  /// the KeyRing associated with the
  ///  [CryptoKeys][google.cloud.kms.v1.CryptoKey].
  /// @param crypto_key_id  Required. It must be unique within a KeyRing and
  /// match the regular
  ///  expression `[a-zA-Z0-9_-]{1,63}`
  /// @param crypto_key  Required. A [CryptoKey][google.cloud.kms.v1.CryptoKey]
  /// with initial field values.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKey,google/cloud/kms/v1/resources.proto#L54}
  ///
  /// [google.cloud.kms.v1.CreateCryptoKeyRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L609}
  /// [google.cloud.kms.v1.CryptoKey]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L54}
  ///
  StatusOr<google::cloud::kms::v1::CryptoKey> CreateCryptoKey(
      std::string const& parent, std::string const& crypto_key_id,
      google::cloud::kms::v1::CryptoKey const& crypto_key,
      Options options = {});

  ///
  /// Create a new [CryptoKey][google.cloud.kms.v1.CryptoKey] within a
  /// [KeyRing][google.cloud.kms.v1.KeyRing].
  ///
  /// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] and
  /// [CryptoKey.version_template.algorithm][google.cloud.kms.v1.CryptoKeyVersionTemplate.algorithm]
  /// are required.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::CreateCryptoKeyRequest,google/cloud/kms/v1/service.proto#L609}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKey,google/cloud/kms/v1/resources.proto#L54}
  ///
  /// [google.cloud.kms.v1.CreateCryptoKeyRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L609}
  /// [google.cloud.kms.v1.CryptoKey]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L54}
  ///
  StatusOr<google::cloud::kms::v1::CryptoKey> CreateCryptoKey(
      google::cloud::kms::v1::CreateCryptoKeyRequest const& request,
      Options options = {});

  ///
  /// Create a new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in a
  /// [CryptoKey][google.cloud.kms.v1.CryptoKey].
  ///
  /// The server will assign the next sequential id. If unset,
  /// [state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
  /// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED].
  ///
  /// @param parent  Required. The [name][google.cloud.kms.v1.CryptoKey.name] of
  /// the [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with
  ///  the [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion].
  /// @param crypto_key_version  Required. A
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with initial
  /// field values.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKeyVersion,google/cloud/kms/v1/resources.proto#L214}
  ///
  /// [google.cloud.kms.v1.CreateCryptoKeyVersionRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L635}
  /// [google.cloud.kms.v1.CryptoKeyVersion]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L214}
  ///
  StatusOr<google::cloud::kms::v1::CryptoKeyVersion> CreateCryptoKeyVersion(
      std::string const& parent,
      google::cloud::kms::v1::CryptoKeyVersion const& crypto_key_version,
      Options options = {});

  ///
  /// Create a new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in a
  /// [CryptoKey][google.cloud.kms.v1.CryptoKey].
  ///
  /// The server will assign the next sequential id. If unset,
  /// [state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
  /// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::CreateCryptoKeyVersionRequest,google/cloud/kms/v1/service.proto#L635}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKeyVersion,google/cloud/kms/v1/resources.proto#L214}
  ///
  /// [google.cloud.kms.v1.CreateCryptoKeyVersionRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L635}
  /// [google.cloud.kms.v1.CryptoKeyVersion]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L214}
  ///
  StatusOr<google::cloud::kms::v1::CryptoKeyVersion> CreateCryptoKeyVersion(
      google::cloud::kms::v1::CreateCryptoKeyVersionRequest const& request,
      Options options = {});

  ///
  /// Import wrapped key material into a
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
  ///
  /// All requests must specify a [CryptoKey][google.cloud.kms.v1.CryptoKey]. If
  /// a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] is additionally
  /// specified in the request, key material will be reimported into that
  /// version. Otherwise, a new version will be created, and will be assigned
  /// the next sequential id within the
  /// [CryptoKey][google.cloud.kms.v1.CryptoKey].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::ImportCryptoKeyVersionRequest,google/cloud/kms/v1/service.proto#L650}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKeyVersion,google/cloud/kms/v1/resources.proto#L214}
  ///
  /// [google.cloud.kms.v1.ImportCryptoKeyVersionRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L650}
  /// [google.cloud.kms.v1.CryptoKeyVersion]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L214}
  ///
  StatusOr<google::cloud::kms::v1::CryptoKeyVersion> ImportCryptoKeyVersion(
      google::cloud::kms::v1::ImportCryptoKeyVersionRequest const& request,
      Options options = {});

  ///
  /// Create a new [ImportJob][google.cloud.kms.v1.ImportJob] within a
  /// [KeyRing][google.cloud.kms.v1.KeyRing].
  ///
  /// [ImportJob.import_method][google.cloud.kms.v1.ImportJob.import_method] is
  /// required.
  ///
  /// @param parent  Required. The [name][google.cloud.kms.v1.KeyRing.name] of
  /// the [KeyRing][google.cloud.kms.v1.KeyRing] associated with the
  ///  [ImportJobs][google.cloud.kms.v1.ImportJob].
  /// @param import_job_id  Required. It must be unique within a KeyRing and
  /// match the regular
  ///  expression `[a-zA-Z0-9_-]{1,63}`
  /// @param import_job  Required. An [ImportJob][google.cloud.kms.v1.ImportJob]
  /// with initial field values.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::ImportJob,google/cloud/kms/v1/resources.proto#L528}
  ///
  /// [google.cloud.kms.v1.CreateImportJobRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L724}
  /// [google.cloud.kms.v1.ImportJob]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L528}
  ///
  StatusOr<google::cloud::kms::v1::ImportJob> CreateImportJob(
      std::string const& parent, std::string const& import_job_id,
      google::cloud::kms::v1::ImportJob const& import_job,
      Options options = {});

  ///
  /// Create a new [ImportJob][google.cloud.kms.v1.ImportJob] within a
  /// [KeyRing][google.cloud.kms.v1.KeyRing].
  ///
  /// [ImportJob.import_method][google.cloud.kms.v1.ImportJob.import_method] is
  /// required.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::CreateImportJobRequest,google/cloud/kms/v1/service.proto#L724}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::ImportJob,google/cloud/kms/v1/resources.proto#L528}
  ///
  /// [google.cloud.kms.v1.CreateImportJobRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L724}
  /// [google.cloud.kms.v1.ImportJob]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L528}
  ///
  StatusOr<google::cloud::kms::v1::ImportJob> CreateImportJob(
      google::cloud::kms::v1::CreateImportJobRequest const& request,
      Options options = {});

  ///
  /// Update a [CryptoKey][google.cloud.kms.v1.CryptoKey].
  ///
  /// @param crypto_key  Required. [CryptoKey][google.cloud.kms.v1.CryptoKey]
  /// with updated values.
  /// @param update_mask  Required. List of fields to be updated in this
  /// request.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKey,google/cloud/kms/v1/resources.proto#L54}
  ///
  /// [google.cloud.kms.v1.UpdateCryptoKeyRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L743}
  /// [google.cloud.kms.v1.CryptoKey]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L54}
  ///
  StatusOr<google::cloud::kms::v1::CryptoKey> UpdateCryptoKey(
      google::cloud::kms::v1::CryptoKey const& crypto_key,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Update a [CryptoKey][google.cloud.kms.v1.CryptoKey].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::UpdateCryptoKeyRequest,google/cloud/kms/v1/service.proto#L743}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKey,google/cloud/kms/v1/resources.proto#L54}
  ///
  /// [google.cloud.kms.v1.UpdateCryptoKeyRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L743}
  /// [google.cloud.kms.v1.CryptoKey]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L54}
  ///
  StatusOr<google::cloud::kms::v1::CryptoKey> UpdateCryptoKey(
      google::cloud::kms::v1::UpdateCryptoKeyRequest const& request,
      Options options = {});

  ///
  /// Update a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s
  /// metadata.
  ///
  /// [state][google.cloud.kms.v1.CryptoKeyVersion.state] may be changed between
  /// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
  /// and
  /// [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED]
  /// using this method. See
  /// [DestroyCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.DestroyCryptoKeyVersion]
  /// and
  /// [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion]
  /// to move between other states.
  ///
  /// @param crypto_key_version  Required.
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with updated
  /// values.
  /// @param update_mask  Required. List of fields to be updated in this
  /// request.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKeyVersion,google/cloud/kms/v1/resources.proto#L214}
  ///
  /// [google.cloud.kms.v1.UpdateCryptoKeyVersionRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L752}
  /// [google.cloud.kms.v1.CryptoKeyVersion]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L214}
  ///
  StatusOr<google::cloud::kms::v1::CryptoKeyVersion> UpdateCryptoKeyVersion(
      google::cloud::kms::v1::CryptoKeyVersion const& crypto_key_version,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Update a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s
  /// metadata.
  ///
  /// [state][google.cloud.kms.v1.CryptoKeyVersion.state] may be changed between
  /// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
  /// and
  /// [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED]
  /// using this method. See
  /// [DestroyCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.DestroyCryptoKeyVersion]
  /// and
  /// [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion]
  /// to move between other states.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::UpdateCryptoKeyVersionRequest,google/cloud/kms/v1/service.proto#L752}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKeyVersion,google/cloud/kms/v1/resources.proto#L214}
  ///
  /// [google.cloud.kms.v1.UpdateCryptoKeyVersionRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L752}
  /// [google.cloud.kms.v1.CryptoKeyVersion]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L214}
  ///
  StatusOr<google::cloud::kms::v1::CryptoKeyVersion> UpdateCryptoKeyVersion(
      google::cloud::kms::v1::UpdateCryptoKeyVersionRequest const& request,
      Options options = {});

  ///
  /// Update the version of a [CryptoKey][google.cloud.kms.v1.CryptoKey] that
  /// will be used in
  /// [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
  ///
  /// Returns an error if called on a key whose purpose is not
  /// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
  ///
  /// @param name  Required. The resource name of the
  /// [CryptoKey][google.cloud.kms.v1.CryptoKey] to update.
  /// @param crypto_key_version_id  Required. The id of the child
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use as
  /// primary.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKey,google/cloud/kms/v1/resources.proto#L54}
  ///
  /// [google.cloud.kms.v1.UpdateCryptoKeyPrimaryVersionRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L761}
  /// [google.cloud.kms.v1.CryptoKey]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L54}
  ///
  StatusOr<google::cloud::kms::v1::CryptoKey> UpdateCryptoKeyPrimaryVersion(
      std::string const& name, std::string const& crypto_key_version_id,
      Options options = {});

  ///
  /// Update the version of a [CryptoKey][google.cloud.kms.v1.CryptoKey] that
  /// will be used in
  /// [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
  ///
  /// Returns an error if called on a key whose purpose is not
  /// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::UpdateCryptoKeyPrimaryVersionRequest,google/cloud/kms/v1/service.proto#L761}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKey,google/cloud/kms/v1/resources.proto#L54}
  ///
  /// [google.cloud.kms.v1.UpdateCryptoKeyPrimaryVersionRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L761}
  /// [google.cloud.kms.v1.CryptoKey]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L54}
  ///
  StatusOr<google::cloud::kms::v1::CryptoKey> UpdateCryptoKeyPrimaryVersion(
      google::cloud::kms::v1::UpdateCryptoKeyPrimaryVersionRequest const&
          request,
      Options options = {});

  ///
  /// Schedule a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] for
  /// destruction.
  ///
  /// Upon calling this method,
  /// [CryptoKeyVersion.state][google.cloud.kms.v1.CryptoKeyVersion.state] will
  /// be set to
  /// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED],
  /// and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will
  /// be set to the time
  /// [destroy_scheduled_duration][google.cloud.kms.v1.CryptoKey.destroy_scheduled_duration]
  /// in the future. At that time, the
  /// [state][google.cloud.kms.v1.CryptoKeyVersion.state] will automatically
  /// change to
  /// [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED],
  /// and the key material will be irrevocably destroyed.
  ///
  /// Before the
  /// [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] is
  /// reached,
  /// [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion]
  /// may be called to reverse the process.
  ///
  /// @param name  Required. The resource name of the
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to destroy.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKeyVersion,google/cloud/kms/v1/resources.proto#L214}
  ///
  /// [google.cloud.kms.v1.DestroyCryptoKeyVersionRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L775}
  /// [google.cloud.kms.v1.CryptoKeyVersion]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L214}
  ///
  StatusOr<google::cloud::kms::v1::CryptoKeyVersion> DestroyCryptoKeyVersion(
      std::string const& name, Options options = {});

  ///
  /// Schedule a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] for
  /// destruction.
  ///
  /// Upon calling this method,
  /// [CryptoKeyVersion.state][google.cloud.kms.v1.CryptoKeyVersion.state] will
  /// be set to
  /// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED],
  /// and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will
  /// be set to the time
  /// [destroy_scheduled_duration][google.cloud.kms.v1.CryptoKey.destroy_scheduled_duration]
  /// in the future. At that time, the
  /// [state][google.cloud.kms.v1.CryptoKeyVersion.state] will automatically
  /// change to
  /// [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED],
  /// and the key material will be irrevocably destroyed.
  ///
  /// Before the
  /// [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] is
  /// reached,
  /// [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion]
  /// may be called to reverse the process.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::DestroyCryptoKeyVersionRequest,google/cloud/kms/v1/service.proto#L775}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKeyVersion,google/cloud/kms/v1/resources.proto#L214}
  ///
  /// [google.cloud.kms.v1.DestroyCryptoKeyVersionRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L775}
  /// [google.cloud.kms.v1.CryptoKeyVersion]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L214}
  ///
  StatusOr<google::cloud::kms::v1::CryptoKeyVersion> DestroyCryptoKeyVersion(
      google::cloud::kms::v1::DestroyCryptoKeyVersionRequest const& request,
      Options options = {});

  ///
  /// Restore a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the
  /// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
  /// state.
  ///
  /// Upon restoration of the CryptoKeyVersion,
  /// [state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
  /// [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED],
  /// and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will
  /// be cleared.
  ///
  /// @param name  Required. The resource name of the
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to restore.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKeyVersion,google/cloud/kms/v1/resources.proto#L214}
  ///
  /// [google.cloud.kms.v1.RestoreCryptoKeyVersionRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L786}
  /// [google.cloud.kms.v1.CryptoKeyVersion]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L214}
  ///
  StatusOr<google::cloud::kms::v1::CryptoKeyVersion> RestoreCryptoKeyVersion(
      std::string const& name, Options options = {});

  ///
  /// Restore a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the
  /// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
  /// state.
  ///
  /// Upon restoration of the CryptoKeyVersion,
  /// [state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
  /// [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED],
  /// and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will
  /// be cleared.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::RestoreCryptoKeyVersionRequest,google/cloud/kms/v1/service.proto#L786}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::CryptoKeyVersion,google/cloud/kms/v1/resources.proto#L214}
  ///
  /// [google.cloud.kms.v1.RestoreCryptoKeyVersionRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L786}
  /// [google.cloud.kms.v1.CryptoKeyVersion]:
  /// @googleapis_reference_link{google/cloud/kms/v1/resources.proto#L214}
  ///
  StatusOr<google::cloud::kms::v1::CryptoKeyVersion> RestoreCryptoKeyVersion(
      google::cloud::kms::v1::RestoreCryptoKeyVersionRequest const& request,
      Options options = {});

  ///
  /// Encrypts data, so that it can only be recovered by a call to
  /// [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt]. The
  /// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
  /// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
  ///
  /// @param name  Required. The resource name of the
  /// [CryptoKey][google.cloud.kms.v1.CryptoKey] or
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
  ///  to use for encryption.
  ///  If a [CryptoKey][google.cloud.kms.v1.CryptoKey] is specified, the server
  ///  will use its [primary version][google.cloud.kms.v1.CryptoKey.primary].
  /// @param plaintext  Required. The data to encrypt. Must be no larger than
  /// 64KiB.
  ///  The maximum size depends on the key version's
  ///  [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level].
  ///  For [SOFTWARE][google.cloud.kms.v1.ProtectionLevel.SOFTWARE] keys, the
  ///  plaintext must be no larger than 64KiB. For
  ///  [HSM][google.cloud.kms.v1.ProtectionLevel.HSM] keys, the combined length
  ///  of the plaintext and additional_authenticated_data fields must be no
  ///  larger than 8KiB.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::EncryptResponse,google/cloud/kms/v1/service.proto#L1090}
  ///
  /// [google.cloud.kms.v1.EncryptRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L797}
  /// [google.cloud.kms.v1.EncryptResponse]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L1090}
  ///
  StatusOr<google::cloud::kms::v1::EncryptResponse> Encrypt(
      std::string const& name, std::string const& plaintext,
      Options options = {});

  ///
  /// Encrypts data, so that it can only be recovered by a call to
  /// [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt]. The
  /// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
  /// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::EncryptRequest,google/cloud/kms/v1/service.proto#L797}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::EncryptResponse,google/cloud/kms/v1/service.proto#L1090}
  ///
  /// [google.cloud.kms.v1.EncryptRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L797}
  /// [google.cloud.kms.v1.EncryptResponse]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L1090}
  ///
  StatusOr<google::cloud::kms::v1::EncryptResponse> Encrypt(
      google::cloud::kms::v1::EncryptRequest const& request,
      Options options = {});

  ///
  /// Decrypts data that was protected by
  /// [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt]. The
  /// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
  /// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
  ///
  /// @param name  Required. The resource name of the
  /// [CryptoKey][google.cloud.kms.v1.CryptoKey] to use for decryption.
  ///  The server will choose the appropriate version.
  /// @param ciphertext  Required. The encrypted data originally returned in
  ///  [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::DecryptResponse,google/cloud/kms/v1/service.proto#L1137}
  ///
  /// [google.cloud.kms.v1.DecryptRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L864}
  /// [google.cloud.kms.v1.DecryptResponse]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L1137}
  ///
  StatusOr<google::cloud::kms::v1::DecryptResponse> Decrypt(
      std::string const& name, std::string const& ciphertext,
      Options options = {});

  ///
  /// Decrypts data that was protected by
  /// [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt]. The
  /// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
  /// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::DecryptRequest,google/cloud/kms/v1/service.proto#L864}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::DecryptResponse,google/cloud/kms/v1/service.proto#L1137}
  ///
  /// [google.cloud.kms.v1.DecryptRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L864}
  /// [google.cloud.kms.v1.DecryptResponse]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L1137}
  ///
  StatusOr<google::cloud::kms::v1::DecryptResponse> Decrypt(
      google::cloud::kms::v1::DecryptRequest const& request,
      Options options = {});

  ///
  /// Signs data using a
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with
  /// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
  /// ASYMMETRIC_SIGN, producing a signature that can be verified with the
  /// public key retrieved from
  /// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
  ///
  /// @param name  Required. The resource name of the
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
  /// signing.
  /// @param digest  Optional. The digest of the data to sign. The digest must
  /// be produced with
  ///  the same digest algorithm as specified by the key version's
  ///  [algorithm][google.cloud.kms.v1.CryptoKeyVersion.algorithm].
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::AsymmetricSignResponse,google/cloud/kms/v1/service.proto#L1164}
  ///
  /// [google.cloud.kms.v1.AsymmetricSignRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L915}
  /// [google.cloud.kms.v1.AsymmetricSignResponse]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L1164}
  ///
  StatusOr<google::cloud::kms::v1::AsymmetricSignResponse> AsymmetricSign(
      std::string const& name, google::cloud::kms::v1::Digest const& digest,
      Options options = {});

  ///
  /// Signs data using a
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with
  /// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
  /// ASYMMETRIC_SIGN, producing a signature that can be verified with the
  /// public key retrieved from
  /// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::AsymmetricSignRequest,google/cloud/kms/v1/service.proto#L915}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::AsymmetricSignResponse,google/cloud/kms/v1/service.proto#L1164}
  ///
  /// [google.cloud.kms.v1.AsymmetricSignRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L915}
  /// [google.cloud.kms.v1.AsymmetricSignResponse]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L1164}
  ///
  StatusOr<google::cloud::kms::v1::AsymmetricSignResponse> AsymmetricSign(
      google::cloud::kms::v1::AsymmetricSignRequest const& request,
      Options options = {});

  ///
  /// Decrypts data that was encrypted with a public key retrieved from
  /// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey]
  /// corresponding to a
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with
  /// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
  /// ASYMMETRIC_DECRYPT.
  ///
  /// @param name  Required. The resource name of the
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
  ///  decryption.
  /// @param ciphertext  Required. The data encrypted with the named
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s public
  ///  key using OAEP.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::AsymmetricDecryptResponse,google/cloud/kms/v1/service.proto#L1210}
  ///
  /// [google.cloud.kms.v1.AsymmetricDecryptRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L966}
  /// [google.cloud.kms.v1.AsymmetricDecryptResponse]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L1210}
  ///
  StatusOr<google::cloud::kms::v1::AsymmetricDecryptResponse> AsymmetricDecrypt(
      std::string const& name, std::string const& ciphertext,
      Options options = {});

  ///
  /// Decrypts data that was encrypted with a public key retrieved from
  /// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey]
  /// corresponding to a
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with
  /// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
  /// ASYMMETRIC_DECRYPT.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::AsymmetricDecryptRequest,google/cloud/kms/v1/service.proto#L966}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::AsymmetricDecryptResponse,google/cloud/kms/v1/service.proto#L1210}
  ///
  /// [google.cloud.kms.v1.AsymmetricDecryptRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L966}
  /// [google.cloud.kms.v1.AsymmetricDecryptResponse]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L1210}
  ///
  StatusOr<google::cloud::kms::v1::AsymmetricDecryptResponse> AsymmetricDecrypt(
      google::cloud::kms::v1::AsymmetricDecryptRequest const& request,
      Options options = {});

  ///
  /// Signs data using a
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with
  /// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] MAC, producing
  /// a tag that can be verified by another source with the same key.
  ///
  /// @param name  Required. The resource name of the
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
  /// signing.
  /// @param data  Required. The data to sign. The MAC tag is computed over this
  /// data field based on
  ///  the specific algorithm.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::MacSignResponse,google/cloud/kms/v1/service.proto#L1242}
  ///
  /// [google.cloud.kms.v1.MacSignRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L997}
  /// [google.cloud.kms.v1.MacSignResponse]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L1242}
  ///
  StatusOr<google::cloud::kms::v1::MacSignResponse> MacSign(
      std::string const& name, std::string const& data, Options options = {});

  ///
  /// Signs data using a
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with
  /// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] MAC, producing
  /// a tag that can be verified by another source with the same key.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::MacSignRequest,google/cloud/kms/v1/service.proto#L997}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::MacSignResponse,google/cloud/kms/v1/service.proto#L1242}
  ///
  /// [google.cloud.kms.v1.MacSignRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L997}
  /// [google.cloud.kms.v1.MacSignResponse]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L1242}
  ///
  StatusOr<google::cloud::kms::v1::MacSignResponse> MacSign(
      google::cloud::kms::v1::MacSignRequest const& request,
      Options options = {});

  ///
  /// Verifies MAC tag using a
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with
  /// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] MAC, and
  /// returns a response that indicates whether or not the verification was
  /// successful.
  ///
  /// @param name  Required. The resource name of the
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
  /// verification.
  /// @param data  Required. The data used previously as a
  /// [MacSignRequest.data][google.cloud.kms.v1.MacSignRequest.data] to generate
  /// the MAC
  ///  tag.
  /// @param mac  Required. The signature to verify.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::MacVerifyResponse,google/cloud/kms/v1/service.proto#L1278}
  ///
  /// [google.cloud.kms.v1.MacVerifyRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L1027}
  /// [google.cloud.kms.v1.MacVerifyResponse]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L1278}
  ///
  StatusOr<google::cloud::kms::v1::MacVerifyResponse> MacVerify(
      std::string const& name, std::string const& data, std::string const& mac,
      Options options = {});

  ///
  /// Verifies MAC tag using a
  /// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with
  /// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] MAC, and
  /// returns a response that indicates whether or not the verification was
  /// successful.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::MacVerifyRequest,google/cloud/kms/v1/service.proto#L1027}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::MacVerifyResponse,google/cloud/kms/v1/service.proto#L1278}
  ///
  /// [google.cloud.kms.v1.MacVerifyRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L1027}
  /// [google.cloud.kms.v1.MacVerifyResponse]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L1278}
  ///
  StatusOr<google::cloud::kms::v1::MacVerifyResponse> MacVerify(
      google::cloud::kms::v1::MacVerifyRequest const& request,
      Options options = {});

  ///
  /// Generate random bytes using the Cloud KMS randomness source in the
  /// provided location.
  ///
  /// @param location  The project-specific location in which to generate random
  /// bytes.
  ///  For example, "projects/my-project/locations/us-central1".
  /// @param length_bytes  The length in bytes of the amount of randomness to
  /// retrieve.  Minimum 8
  ///  bytes, maximum 1024 bytes.
  /// @param protection_level  The
  /// [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] to use when
  /// generating the random data. Defaults to
  ///  [SOFTWARE][google.cloud.kms.v1.ProtectionLevel.SOFTWARE].
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::GenerateRandomBytesResponse,google/cloud/kms/v1/service.proto#L1319}
  ///
  /// [google.cloud.kms.v1.GenerateRandomBytesRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L1075}
  /// [google.cloud.kms.v1.GenerateRandomBytesResponse]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L1319}
  ///
  StatusOr<google::cloud::kms::v1::GenerateRandomBytesResponse>
  GenerateRandomBytes(std::string const& location, std::int32_t length_bytes,
                      google::cloud::kms::v1::ProtectionLevel protection_level,
                      Options options = {});

  ///
  /// Generate random bytes using the Cloud KMS randomness source in the
  /// provided location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::kms::v1::GenerateRandomBytesRequest,google/cloud/kms/v1/service.proto#L1075}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::kms::v1::GenerateRandomBytesResponse,google/cloud/kms/v1/service.proto#L1319}
  ///
  /// [google.cloud.kms.v1.GenerateRandomBytesRequest]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L1075}
  /// [google.cloud.kms.v1.GenerateRandomBytesResponse]:
  /// @googleapis_reference_link{google/cloud/kms/v1/service.proto#L1319}
  ///
  StatusOr<google::cloud::kms::v1::GenerateRandomBytesResponse>
  GenerateRandomBytes(
      google::cloud::kms::v1::GenerateRandomBytesRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<KeyManagementServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace kms
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_KMS_KEY_MANAGEMENT_CLIENT_H
