// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/iot/v1/device_manager.proto

#include "google/cloud/iot/internal/device_manager_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/iot/v1/device_manager.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace iot_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DeviceManagerStub::~DeviceManagerStub() = default;

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DefaultDeviceManagerStub::CreateDeviceRegistry(
    grpc::ClientContext& client_context,
    google::cloud::iot::v1::CreateDeviceRegistryRequest const& request) {
  google::cloud::iot::v1::DeviceRegistry response;
  auto status =
      grpc_stub_->CreateDeviceRegistry(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DefaultDeviceManagerStub::GetDeviceRegistry(
    grpc::ClientContext& client_context,
    google::cloud::iot::v1::GetDeviceRegistryRequest const& request) {
  google::cloud::iot::v1::DeviceRegistry response;
  auto status =
      grpc_stub_->GetDeviceRegistry(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DefaultDeviceManagerStub::UpdateDeviceRegistry(
    grpc::ClientContext& client_context,
    google::cloud::iot::v1::UpdateDeviceRegistryRequest const& request) {
  google::cloud::iot::v1::DeviceRegistry response;
  auto status =
      grpc_stub_->UpdateDeviceRegistry(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultDeviceManagerStub::DeleteDeviceRegistry(
    grpc::ClientContext& client_context,
    google::cloud::iot::v1::DeleteDeviceRegistryRequest const& request) {
  google::protobuf::Empty response;
  auto status =
      grpc_stub_->DeleteDeviceRegistry(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::cloud::iot::v1::ListDeviceRegistriesResponse>
DefaultDeviceManagerStub::ListDeviceRegistries(
    grpc::ClientContext& client_context,
    google::cloud::iot::v1::ListDeviceRegistriesRequest const& request) {
  google::cloud::iot::v1::ListDeviceRegistriesResponse response;
  auto status =
      grpc_stub_->ListDeviceRegistries(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::iot::v1::Device> DefaultDeviceManagerStub::CreateDevice(
    grpc::ClientContext& client_context,
    google::cloud::iot::v1::CreateDeviceRequest const& request) {
  google::cloud::iot::v1::Device response;
  auto status = grpc_stub_->CreateDevice(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::iot::v1::Device> DefaultDeviceManagerStub::GetDevice(
    grpc::ClientContext& client_context,
    google::cloud::iot::v1::GetDeviceRequest const& request) {
  google::cloud::iot::v1::Device response;
  auto status = grpc_stub_->GetDevice(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::iot::v1::Device> DefaultDeviceManagerStub::UpdateDevice(
    grpc::ClientContext& client_context,
    google::cloud::iot::v1::UpdateDeviceRequest const& request) {
  google::cloud::iot::v1::Device response;
  auto status = grpc_stub_->UpdateDevice(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultDeviceManagerStub::DeleteDevice(
    grpc::ClientContext& client_context,
    google::cloud::iot::v1::DeleteDeviceRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteDevice(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::cloud::iot::v1::ListDevicesResponse>
DefaultDeviceManagerStub::ListDevices(
    grpc::ClientContext& client_context,
    google::cloud::iot::v1::ListDevicesRequest const& request) {
  google::cloud::iot::v1::ListDevicesResponse response;
  auto status = grpc_stub_->ListDevices(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::iot::v1::DeviceConfig>
DefaultDeviceManagerStub::ModifyCloudToDeviceConfig(
    grpc::ClientContext& client_context,
    google::cloud::iot::v1::ModifyCloudToDeviceConfigRequest const& request) {
  google::cloud::iot::v1::DeviceConfig response;
  auto status = grpc_stub_->ModifyCloudToDeviceConfig(&client_context, request,
                                                      &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::iot::v1::ListDeviceConfigVersionsResponse>
DefaultDeviceManagerStub::ListDeviceConfigVersions(
    grpc::ClientContext& client_context,
    google::cloud::iot::v1::ListDeviceConfigVersionsRequest const& request) {
  google::cloud::iot::v1::ListDeviceConfigVersionsResponse response;
  auto status =
      grpc_stub_->ListDeviceConfigVersions(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::iot::v1::ListDeviceStatesResponse>
DefaultDeviceManagerStub::ListDeviceStates(
    grpc::ClientContext& client_context,
    google::cloud::iot::v1::ListDeviceStatesRequest const& request) {
  google::cloud::iot::v1::ListDeviceStatesResponse response;
  auto status =
      grpc_stub_->ListDeviceStates(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::iam::v1::Policy> DefaultDeviceManagerStub::SetIamPolicy(
    grpc::ClientContext& client_context,
    google::iam::v1::SetIamPolicyRequest const& request) {
  google::iam::v1::Policy response;
  auto status = grpc_stub_->SetIamPolicy(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::iam::v1::Policy> DefaultDeviceManagerStub::GetIamPolicy(
    grpc::ClientContext& client_context,
    google::iam::v1::GetIamPolicyRequest const& request) {
  google::iam::v1::Policy response;
  auto status = grpc_stub_->GetIamPolicy(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DefaultDeviceManagerStub::TestIamPermissions(
    grpc::ClientContext& client_context,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  google::iam::v1::TestIamPermissionsResponse response;
  auto status =
      grpc_stub_->TestIamPermissions(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::iot::v1::SendCommandToDeviceResponse>
DefaultDeviceManagerStub::SendCommandToDevice(
    grpc::ClientContext& client_context,
    google::cloud::iot::v1::SendCommandToDeviceRequest const& request) {
  google::cloud::iot::v1::SendCommandToDeviceResponse response;
  auto status =
      grpc_stub_->SendCommandToDevice(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::iot::v1::BindDeviceToGatewayResponse>
DefaultDeviceManagerStub::BindDeviceToGateway(
    grpc::ClientContext& client_context,
    google::cloud::iot::v1::BindDeviceToGatewayRequest const& request) {
  google::cloud::iot::v1::BindDeviceToGatewayResponse response;
  auto status =
      grpc_stub_->BindDeviceToGateway(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::iot::v1::UnbindDeviceFromGatewayResponse>
DefaultDeviceManagerStub::UnbindDeviceFromGateway(
    grpc::ClientContext& client_context,
    google::cloud::iot::v1::UnbindDeviceFromGatewayRequest const& request) {
  google::cloud::iot::v1::UnbindDeviceFromGatewayResponse response;
  auto status =
      grpc_stub_->UnbindDeviceFromGateway(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iot_internal
}  // namespace cloud
}  // namespace google
