// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/iot/v1/device_manager.proto

#include "google/cloud/iot/internal/device_manager_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/iot/v1/device_manager.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace iot_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DeviceManagerLogging::DeviceManagerLogging(
    std::shared_ptr<DeviceManagerStub> child, TracingOptions tracing_options,
    std::set<std::string> components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      components_(std::move(components)) {}

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerLogging::CreateDeviceRegistry(
    grpc::ClientContext& context,
    google::cloud::iot::v1::CreateDeviceRegistryRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::iot::v1::CreateDeviceRegistryRequest const& request) {
        return child_->CreateDeviceRegistry(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerLogging::GetDeviceRegistry(
    grpc::ClientContext& context,
    google::cloud::iot::v1::GetDeviceRegistryRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::iot::v1::GetDeviceRegistryRequest const& request) {
        return child_->GetDeviceRegistry(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerLogging::UpdateDeviceRegistry(
    grpc::ClientContext& context,
    google::cloud::iot::v1::UpdateDeviceRegistryRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::iot::v1::UpdateDeviceRegistryRequest const& request) {
        return child_->UpdateDeviceRegistry(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status DeviceManagerLogging::DeleteDeviceRegistry(
    grpc::ClientContext& context,
    google::cloud::iot::v1::DeleteDeviceRegistryRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::iot::v1::DeleteDeviceRegistryRequest const& request) {
        return child_->DeleteDeviceRegistry(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::iot::v1::ListDeviceRegistriesResponse>
DeviceManagerLogging::ListDeviceRegistries(
    grpc::ClientContext& context,
    google::cloud::iot::v1::ListDeviceRegistriesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::iot::v1::ListDeviceRegistriesRequest const& request) {
        return child_->ListDeviceRegistries(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::iot::v1::Device> DeviceManagerLogging::CreateDevice(
    grpc::ClientContext& context,
    google::cloud::iot::v1::CreateDeviceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::iot::v1::CreateDeviceRequest const& request) {
        return child_->CreateDevice(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::iot::v1::Device> DeviceManagerLogging::GetDevice(
    grpc::ClientContext& context,
    google::cloud::iot::v1::GetDeviceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::iot::v1::GetDeviceRequest const& request) {
        return child_->GetDevice(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::iot::v1::Device> DeviceManagerLogging::UpdateDevice(
    grpc::ClientContext& context,
    google::cloud::iot::v1::UpdateDeviceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::iot::v1::UpdateDeviceRequest const& request) {
        return child_->UpdateDevice(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status DeviceManagerLogging::DeleteDevice(
    grpc::ClientContext& context,
    google::cloud::iot::v1::DeleteDeviceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::iot::v1::DeleteDeviceRequest const& request) {
        return child_->DeleteDevice(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::iot::v1::ListDevicesResponse>
DeviceManagerLogging::ListDevices(
    grpc::ClientContext& context,
    google::cloud::iot::v1::ListDevicesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::iot::v1::ListDevicesRequest const& request) {
        return child_->ListDevices(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::iot::v1::DeviceConfig>
DeviceManagerLogging::ModifyCloudToDeviceConfig(
    grpc::ClientContext& context,
    google::cloud::iot::v1::ModifyCloudToDeviceConfigRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::iot::v1::ModifyCloudToDeviceConfigRequest const&
                 request) {
        return child_->ModifyCloudToDeviceConfig(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::iot::v1::ListDeviceConfigVersionsResponse>
DeviceManagerLogging::ListDeviceConfigVersions(
    grpc::ClientContext& context,
    google::cloud::iot::v1::ListDeviceConfigVersionsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::iot::v1::ListDeviceConfigVersionsRequest const&
                 request) {
        return child_->ListDeviceConfigVersions(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::iot::v1::ListDeviceStatesResponse>
DeviceManagerLogging::ListDeviceStates(
    grpc::ClientContext& context,
    google::cloud::iot::v1::ListDeviceStatesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::iot::v1::ListDeviceStatesRequest const& request) {
        return child_->ListDeviceStates(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::Policy> DeviceManagerLogging::SetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::SetIamPolicyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return child_->SetIamPolicy(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::Policy> DeviceManagerLogging::GetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::GetIamPolicyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return child_->GetIamPolicy(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DeviceManagerLogging::TestIamPermissions(
    grpc::ClientContext& context,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return child_->TestIamPermissions(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::iot::v1::SendCommandToDeviceResponse>
DeviceManagerLogging::SendCommandToDevice(
    grpc::ClientContext& context,
    google::cloud::iot::v1::SendCommandToDeviceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::iot::v1::SendCommandToDeviceRequest const& request) {
        return child_->SendCommandToDevice(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::iot::v1::BindDeviceToGatewayResponse>
DeviceManagerLogging::BindDeviceToGateway(
    grpc::ClientContext& context,
    google::cloud::iot::v1::BindDeviceToGatewayRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::iot::v1::BindDeviceToGatewayRequest const& request) {
        return child_->BindDeviceToGateway(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::iot::v1::UnbindDeviceFromGatewayResponse>
DeviceManagerLogging::UnbindDeviceFromGateway(
    grpc::ClientContext& context,
    google::cloud::iot::v1::UnbindDeviceFromGatewayRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::iot::v1::UnbindDeviceFromGatewayRequest const&
                 request) {
        return child_->UnbindDeviceFromGateway(context, request);
      },
      context, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iot_internal
}  // namespace cloud
}  // namespace google
