// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/iot/v1/device_manager.proto

#include "google/cloud/iot/internal/device_manager_connection_impl.h"
#include "google/cloud/iot/internal/device_manager_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace iot_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DeviceManagerConnectionImpl::DeviceManagerConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<iot_internal::DeviceManagerStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), iot_internal::DeviceManagerDefaultOptions(
                                  DeviceManagerConnection::options()))) {}

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerConnectionImpl::CreateDeviceRegistry(
    google::cloud::iot::v1::CreateDeviceRegistryRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateDeviceRegistry(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::iot::v1::CreateDeviceRegistryRequest const& request) {
        return stub_->CreateDeviceRegistry(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerConnectionImpl::GetDeviceRegistry(
    google::cloud::iot::v1::GetDeviceRegistryRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetDeviceRegistry(request),
      [this](grpc::ClientContext& context,
             google::cloud::iot::v1::GetDeviceRegistryRequest const& request) {
        return stub_->GetDeviceRegistry(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerConnectionImpl::UpdateDeviceRegistry(
    google::cloud::iot::v1::UpdateDeviceRegistryRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateDeviceRegistry(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::iot::v1::UpdateDeviceRegistryRequest const& request) {
        return stub_->UpdateDeviceRegistry(context, request);
      },
      request, __func__);
}

Status DeviceManagerConnectionImpl::DeleteDeviceRegistry(
    google::cloud::iot::v1::DeleteDeviceRegistryRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteDeviceRegistry(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::iot::v1::DeleteDeviceRegistryRequest const& request) {
        return stub_->DeleteDeviceRegistry(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerConnectionImpl::ListDeviceRegistries(
    google::cloud::iot::v1::ListDeviceRegistriesRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<iot::DeviceManagerRetryPolicy const>(retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListDeviceRegistries(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::iot::v1::DeviceRegistry>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::iot::v1::ListDeviceRegistriesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::iot::v1::ListDeviceRegistriesRequest const&
                       request) {
              return stub->ListDeviceRegistries(context, request);
            },
            r, function_name);
      },
      [](google::cloud::iot::v1::ListDeviceRegistriesResponse r) {
        std::vector<google::cloud::iot::v1::DeviceRegistry> result(
            r.device_registries().size());
        auto& messages = *r.mutable_device_registries();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::iot::v1::Device>
DeviceManagerConnectionImpl::CreateDevice(
    google::cloud::iot::v1::CreateDeviceRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateDevice(request),
      [this](grpc::ClientContext& context,
             google::cloud::iot::v1::CreateDeviceRequest const& request) {
        return stub_->CreateDevice(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::iot::v1::Device> DeviceManagerConnectionImpl::GetDevice(
    google::cloud::iot::v1::GetDeviceRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetDevice(request),
      [this](grpc::ClientContext& context,
             google::cloud::iot::v1::GetDeviceRequest const& request) {
        return stub_->GetDevice(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::iot::v1::Device>
DeviceManagerConnectionImpl::UpdateDevice(
    google::cloud::iot::v1::UpdateDeviceRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateDevice(request),
      [this](grpc::ClientContext& context,
             google::cloud::iot::v1::UpdateDeviceRequest const& request) {
        return stub_->UpdateDevice(context, request);
      },
      request, __func__);
}

Status DeviceManagerConnectionImpl::DeleteDevice(
    google::cloud::iot::v1::DeleteDeviceRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteDevice(request),
      [this](grpc::ClientContext& context,
             google::cloud::iot::v1::DeleteDeviceRequest const& request) {
        return stub_->DeleteDevice(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::iot::v1::Device>
DeviceManagerConnectionImpl::ListDevices(
    google::cloud::iot::v1::ListDevicesRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<iot::DeviceManagerRetryPolicy const>(retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListDevices(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::iot::v1::Device>>(
      std::move(request),
      [stub, retry, backoff, idempotency,
       function_name](google::cloud::iot::v1::ListDevicesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::iot::v1::ListDevicesRequest const& request) {
              return stub->ListDevices(context, request);
            },
            r, function_name);
      },
      [](google::cloud::iot::v1::ListDevicesResponse r) {
        std::vector<google::cloud::iot::v1::Device> result(r.devices().size());
        auto& messages = *r.mutable_devices();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::iot::v1::DeviceConfig>
DeviceManagerConnectionImpl::ModifyCloudToDeviceConfig(
    google::cloud::iot::v1::ModifyCloudToDeviceConfigRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->ModifyCloudToDeviceConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::iot::v1::ModifyCloudToDeviceConfigRequest const&
                 request) {
        return stub_->ModifyCloudToDeviceConfig(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::iot::v1::ListDeviceConfigVersionsResponse>
DeviceManagerConnectionImpl::ListDeviceConfigVersions(
    google::cloud::iot::v1::ListDeviceConfigVersionsRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->ListDeviceConfigVersions(request),
      [this](grpc::ClientContext& context,
             google::cloud::iot::v1::ListDeviceConfigVersionsRequest const&
                 request) {
        return stub_->ListDeviceConfigVersions(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::iot::v1::ListDeviceStatesResponse>
DeviceManagerConnectionImpl::ListDeviceStates(
    google::cloud::iot::v1::ListDeviceStatesRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->ListDeviceStates(request),
      [this](grpc::ClientContext& context,
             google::cloud::iot::v1::ListDeviceStatesRequest const& request) {
        return stub_->ListDeviceStates(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::Policy> DeviceManagerConnectionImpl::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SetIamPolicy(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return stub_->SetIamPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::Policy> DeviceManagerConnectionImpl::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetIamPolicy(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return stub_->GetIamPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DeviceManagerConnectionImpl::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->TestIamPermissions(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return stub_->TestIamPermissions(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::iot::v1::SendCommandToDeviceResponse>
DeviceManagerConnectionImpl::SendCommandToDevice(
    google::cloud::iot::v1::SendCommandToDeviceRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SendCommandToDevice(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::iot::v1::SendCommandToDeviceRequest const& request) {
        return stub_->SendCommandToDevice(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::iot::v1::BindDeviceToGatewayResponse>
DeviceManagerConnectionImpl::BindDeviceToGateway(
    google::cloud::iot::v1::BindDeviceToGatewayRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->BindDeviceToGateway(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::iot::v1::BindDeviceToGatewayRequest const& request) {
        return stub_->BindDeviceToGateway(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::iot::v1::UnbindDeviceFromGatewayResponse>
DeviceManagerConnectionImpl::UnbindDeviceFromGateway(
    google::cloud::iot::v1::UnbindDeviceFromGatewayRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UnbindDeviceFromGateway(request),
      [this](grpc::ClientContext& context,
             google::cloud::iot::v1::UnbindDeviceFromGatewayRequest const&
                 request) {
        return stub_->UnbindDeviceFromGateway(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iot_internal
}  // namespace cloud
}  // namespace google
