// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/iot/v1/device_manager.proto

#include "google/cloud/iot/internal/device_manager_auth_decorator.h"
#include <google/cloud/iot/v1/device_manager.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace iot_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DeviceManagerAuth::DeviceManagerAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<DeviceManagerStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerAuth::CreateDeviceRegistry(
    grpc::ClientContext& context,
    google::cloud::iot::v1::CreateDeviceRegistryRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateDeviceRegistry(context, request);
}

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerAuth::GetDeviceRegistry(
    grpc::ClientContext& context,
    google::cloud::iot::v1::GetDeviceRegistryRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetDeviceRegistry(context, request);
}

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerAuth::UpdateDeviceRegistry(
    grpc::ClientContext& context,
    google::cloud::iot::v1::UpdateDeviceRegistryRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateDeviceRegistry(context, request);
}

Status DeviceManagerAuth::DeleteDeviceRegistry(
    grpc::ClientContext& context,
    google::cloud::iot::v1::DeleteDeviceRegistryRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteDeviceRegistry(context, request);
}

StatusOr<google::cloud::iot::v1::ListDeviceRegistriesResponse>
DeviceManagerAuth::ListDeviceRegistries(
    grpc::ClientContext& context,
    google::cloud::iot::v1::ListDeviceRegistriesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListDeviceRegistries(context, request);
}

StatusOr<google::cloud::iot::v1::Device> DeviceManagerAuth::CreateDevice(
    grpc::ClientContext& context,
    google::cloud::iot::v1::CreateDeviceRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateDevice(context, request);
}

StatusOr<google::cloud::iot::v1::Device> DeviceManagerAuth::GetDevice(
    grpc::ClientContext& context,
    google::cloud::iot::v1::GetDeviceRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetDevice(context, request);
}

StatusOr<google::cloud::iot::v1::Device> DeviceManagerAuth::UpdateDevice(
    grpc::ClientContext& context,
    google::cloud::iot::v1::UpdateDeviceRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateDevice(context, request);
}

Status DeviceManagerAuth::DeleteDevice(
    grpc::ClientContext& context,
    google::cloud::iot::v1::DeleteDeviceRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteDevice(context, request);
}

StatusOr<google::cloud::iot::v1::ListDevicesResponse>
DeviceManagerAuth::ListDevices(
    grpc::ClientContext& context,
    google::cloud::iot::v1::ListDevicesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListDevices(context, request);
}

StatusOr<google::cloud::iot::v1::DeviceConfig>
DeviceManagerAuth::ModifyCloudToDeviceConfig(
    grpc::ClientContext& context,
    google::cloud::iot::v1::ModifyCloudToDeviceConfigRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ModifyCloudToDeviceConfig(context, request);
}

StatusOr<google::cloud::iot::v1::ListDeviceConfigVersionsResponse>
DeviceManagerAuth::ListDeviceConfigVersions(
    grpc::ClientContext& context,
    google::cloud::iot::v1::ListDeviceConfigVersionsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListDeviceConfigVersions(context, request);
}

StatusOr<google::cloud::iot::v1::ListDeviceStatesResponse>
DeviceManagerAuth::ListDeviceStates(
    grpc::ClientContext& context,
    google::cloud::iot::v1::ListDeviceStatesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListDeviceStates(context, request);
}

StatusOr<google::iam::v1::Policy> DeviceManagerAuth::SetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SetIamPolicy(context, request);
}

StatusOr<google::iam::v1::Policy> DeviceManagerAuth::GetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetIamPolicy(context, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DeviceManagerAuth::TestIamPermissions(
    grpc::ClientContext& context,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->TestIamPermissions(context, request);
}

StatusOr<google::cloud::iot::v1::SendCommandToDeviceResponse>
DeviceManagerAuth::SendCommandToDevice(
    grpc::ClientContext& context,
    google::cloud::iot::v1::SendCommandToDeviceRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SendCommandToDevice(context, request);
}

StatusOr<google::cloud::iot::v1::BindDeviceToGatewayResponse>
DeviceManagerAuth::BindDeviceToGateway(
    grpc::ClientContext& context,
    google::cloud::iot::v1::BindDeviceToGatewayRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->BindDeviceToGateway(context, request);
}

StatusOr<google::cloud::iot::v1::UnbindDeviceFromGatewayResponse>
DeviceManagerAuth::UnbindDeviceFromGateway(
    grpc::ClientContext& context,
    google::cloud::iot::v1::UnbindDeviceFromGatewayRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UnbindDeviceFromGateway(context, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iot_internal
}  // namespace cloud
}  // namespace google
