// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/iot/v1/device_manager.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_IOT_DEVICE_MANAGER_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_IOT_DEVICE_MANAGER_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/internal/retry_policy.h"
#include "google/cloud/version.h"
#include <google/cloud/iot/v1/device_manager.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace iot {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DeviceManagerConnectionIdempotencyPolicy {
 public:
  virtual ~DeviceManagerConnectionIdempotencyPolicy() = 0;

  /// Create a new copy of this object.
  virtual std::unique_ptr<DeviceManagerConnectionIdempotencyPolicy> clone()
      const = 0;

  virtual google::cloud::Idempotency CreateDeviceRegistry(
      google::cloud::iot::v1::CreateDeviceRegistryRequest const& request) = 0;

  virtual google::cloud::Idempotency GetDeviceRegistry(
      google::cloud::iot::v1::GetDeviceRegistryRequest const& request) = 0;

  virtual google::cloud::Idempotency UpdateDeviceRegistry(
      google::cloud::iot::v1::UpdateDeviceRegistryRequest const& request) = 0;

  virtual google::cloud::Idempotency DeleteDeviceRegistry(
      google::cloud::iot::v1::DeleteDeviceRegistryRequest const& request) = 0;

  virtual google::cloud::Idempotency ListDeviceRegistries(
      google::cloud::iot::v1::ListDeviceRegistriesRequest request) = 0;

  virtual google::cloud::Idempotency CreateDevice(
      google::cloud::iot::v1::CreateDeviceRequest const& request) = 0;

  virtual google::cloud::Idempotency GetDevice(
      google::cloud::iot::v1::GetDeviceRequest const& request) = 0;

  virtual google::cloud::Idempotency UpdateDevice(
      google::cloud::iot::v1::UpdateDeviceRequest const& request) = 0;

  virtual google::cloud::Idempotency DeleteDevice(
      google::cloud::iot::v1::DeleteDeviceRequest const& request) = 0;

  virtual google::cloud::Idempotency ListDevices(
      google::cloud::iot::v1::ListDevicesRequest request) = 0;

  virtual google::cloud::Idempotency ModifyCloudToDeviceConfig(
      google::cloud::iot::v1::ModifyCloudToDeviceConfigRequest const&
          request) = 0;

  virtual google::cloud::Idempotency ListDeviceConfigVersions(
      google::cloud::iot::v1::ListDeviceConfigVersionsRequest const&
          request) = 0;

  virtual google::cloud::Idempotency ListDeviceStates(
      google::cloud::iot::v1::ListDeviceStatesRequest const& request) = 0;

  virtual google::cloud::Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request) = 0;

  virtual google::cloud::Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request) = 0;

  virtual google::cloud::Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request) = 0;

  virtual google::cloud::Idempotency SendCommandToDevice(
      google::cloud::iot::v1::SendCommandToDeviceRequest const& request) = 0;

  virtual google::cloud::Idempotency BindDeviceToGateway(
      google::cloud::iot::v1::BindDeviceToGatewayRequest const& request) = 0;

  virtual google::cloud::Idempotency UnbindDeviceFromGateway(
      google::cloud::iot::v1::UnbindDeviceFromGatewayRequest const&
          request) = 0;
};

std::unique_ptr<DeviceManagerConnectionIdempotencyPolicy>
MakeDefaultDeviceManagerConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iot
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_IOT_DEVICE_MANAGER_CONNECTION_IDEMPOTENCY_POLICY_H
