// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/iot/v1/device_manager.proto

#include "google/cloud/iot/device_manager_connection.h"
#include "google/cloud/iot/device_manager_options.h"
#include "google/cloud/iot/internal/device_manager_connection_impl.h"
#include "google/cloud/iot/internal/device_manager_option_defaults.h"
#include "google/cloud/iot/internal/device_manager_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace iot {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DeviceManagerConnection::~DeviceManagerConnection() = default;

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerConnection::CreateDeviceRegistry(
    google::cloud::iot::v1::CreateDeviceRegistryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerConnection::GetDeviceRegistry(
    google::cloud::iot::v1::GetDeviceRegistryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerConnection::UpdateDeviceRegistry(
    google::cloud::iot::v1::UpdateDeviceRegistryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DeviceManagerConnection::DeleteDeviceRegistry(
    google::cloud::iot::v1::DeleteDeviceRegistryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerConnection::ListDeviceRegistries(
    google::cloud::iot::v1::ListDeviceRegistriesRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::iot::v1::DeviceRegistry>>(
      std::move(request),
      [](google::cloud::iot::v1::ListDeviceRegistriesRequest const&) {
        return StatusOr<google::cloud::iot::v1::ListDeviceRegistriesResponse>{};
      },
      [](google::cloud::iot::v1::ListDeviceRegistriesResponse const&) {
        return std::vector<google::cloud::iot::v1::DeviceRegistry>();
      });
}

StatusOr<google::cloud::iot::v1::Device> DeviceManagerConnection::CreateDevice(
    google::cloud::iot::v1::CreateDeviceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::iot::v1::Device> DeviceManagerConnection::GetDevice(
    google::cloud::iot::v1::GetDeviceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::iot::v1::Device> DeviceManagerConnection::UpdateDevice(
    google::cloud::iot::v1::UpdateDeviceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DeviceManagerConnection::DeleteDevice(
    google::cloud::iot::v1::DeleteDeviceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::iot::v1::Device>
DeviceManagerConnection::ListDevices(
    google::cloud::iot::v1::ListDevicesRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::iot::v1::Device>>(
      std::move(request),
      [](google::cloud::iot::v1::ListDevicesRequest const&) {
        return StatusOr<google::cloud::iot::v1::ListDevicesResponse>{};
      },
      [](google::cloud::iot::v1::ListDevicesResponse const&) {
        return std::vector<google::cloud::iot::v1::Device>();
      });
}

StatusOr<google::cloud::iot::v1::DeviceConfig>
DeviceManagerConnection::ModifyCloudToDeviceConfig(
    google::cloud::iot::v1::ModifyCloudToDeviceConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::iot::v1::ListDeviceConfigVersionsResponse>
DeviceManagerConnection::ListDeviceConfigVersions(
    google::cloud::iot::v1::ListDeviceConfigVersionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::iot::v1::ListDeviceStatesResponse>
DeviceManagerConnection::ListDeviceStates(
    google::cloud::iot::v1::ListDeviceStatesRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> DeviceManagerConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> DeviceManagerConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DeviceManagerConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::iot::v1::SendCommandToDeviceResponse>
DeviceManagerConnection::SendCommandToDevice(
    google::cloud::iot::v1::SendCommandToDeviceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::iot::v1::BindDeviceToGatewayResponse>
DeviceManagerConnection::BindDeviceToGateway(
    google::cloud::iot::v1::BindDeviceToGatewayRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::iot::v1::UnbindDeviceFromGatewayResponse>
DeviceManagerConnection::UnbindDeviceFromGateway(
    google::cloud::iot::v1::UnbindDeviceFromGatewayRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<DeviceManagerConnection> MakeDeviceManagerConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 DeviceManagerPolicyOptionList>(options,
                                                                __func__);
  options = iot_internal::DeviceManagerDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub =
      iot_internal::CreateDefaultDeviceManagerStub(background->cq(), options);
  return std::make_shared<iot_internal::DeviceManagerConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iot
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace iot_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<iot::DeviceManagerConnection> MakeDeviceManagerConnection(
    std::shared_ptr<DeviceManagerStub> stub, Options options) {
  options = DeviceManagerDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<iot_internal::DeviceManagerConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iot_internal
}  // namespace cloud
}  // namespace google
