// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/iot/v1/device_manager.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_IOT_DEVICE_MANAGER_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_IOT_DEVICE_MANAGER_CLIENT_H

#include "google/cloud/iot/device_manager_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/iam_updater.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace iot {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Internet of Things (IoT) service. Securely connect and manage IoT devices.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class DeviceManagerClient {
 public:
  explicit DeviceManagerClient(
      std::shared_ptr<DeviceManagerConnection> connection,
      Options options = {});
  ~DeviceManagerClient();

  //@{
  // @name Copy and move support
  DeviceManagerClient(DeviceManagerClient const&) = default;
  DeviceManagerClient& operator=(DeviceManagerClient const&) = default;
  DeviceManagerClient(DeviceManagerClient&&) = default;
  DeviceManagerClient& operator=(DeviceManagerClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(DeviceManagerClient const& a,
                         DeviceManagerClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(DeviceManagerClient const& a,
                         DeviceManagerClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Creates a device registry that contains devices.
  ///
  /// @param parent  Required. The project and cloud region where this device
  /// registry must be created.
  ///  For example, `projects/example-project/locations/us-central1`.
  /// @param device_registry  Required. The device registry. The field `name`
  /// must be empty. The server will
  ///  generate that field from the device registry `id` provided and the
  ///  `parent` field.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::DeviceRegistry,google/cloud/iot/v1/resources.proto#L155}
  ///
  /// [google.cloud.iot.v1.CreateDeviceRegistryRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L274}
  /// [google.cloud.iot.v1.DeviceRegistry]:
  /// @googleapis_reference_link{google/cloud/iot/v1/resources.proto#L155}
  ///
  StatusOr<google::cloud::iot::v1::DeviceRegistry> CreateDeviceRegistry(
      std::string const& parent,
      google::cloud::iot::v1::DeviceRegistry const& device_registry,
      Options options = {});

  ///
  /// Creates a device registry that contains devices.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::iot::v1::CreateDeviceRegistryRequest,google/cloud/iot/v1/device_manager.proto#L274}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::DeviceRegistry,google/cloud/iot/v1/resources.proto#L155}
  ///
  /// [google.cloud.iot.v1.CreateDeviceRegistryRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L274}
  /// [google.cloud.iot.v1.DeviceRegistry]:
  /// @googleapis_reference_link{google/cloud/iot/v1/resources.proto#L155}
  ///
  StatusOr<google::cloud::iot::v1::DeviceRegistry> CreateDeviceRegistry(
      google::cloud::iot::v1::CreateDeviceRegistryRequest const& request,
      Options options = {});

  ///
  /// Gets a device registry configuration.
  ///
  /// @param name  Required. The name of the device registry. For example,
  ///  `projects/example-project/locations/us-central1/registries/my-registry`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::DeviceRegistry,google/cloud/iot/v1/resources.proto#L155}
  ///
  /// [google.cloud.iot.v1.GetDeviceRegistryRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L291}
  /// [google.cloud.iot.v1.DeviceRegistry]:
  /// @googleapis_reference_link{google/cloud/iot/v1/resources.proto#L155}
  ///
  StatusOr<google::cloud::iot::v1::DeviceRegistry> GetDeviceRegistry(
      std::string const& name, Options options = {});

  ///
  /// Gets a device registry configuration.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::iot::v1::GetDeviceRegistryRequest,google/cloud/iot/v1/device_manager.proto#L291}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::DeviceRegistry,google/cloud/iot/v1/resources.proto#L155}
  ///
  /// [google.cloud.iot.v1.GetDeviceRegistryRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L291}
  /// [google.cloud.iot.v1.DeviceRegistry]:
  /// @googleapis_reference_link{google/cloud/iot/v1/resources.proto#L155}
  ///
  StatusOr<google::cloud::iot::v1::DeviceRegistry> GetDeviceRegistry(
      google::cloud::iot::v1::GetDeviceRegistryRequest const& request,
      Options options = {});

  ///
  /// Updates a device registry configuration.
  ///
  /// @param device_registry  Required. The new values for the device registry.
  /// The `id` field must be empty, and
  ///  the `name` field must indicate the path of the resource. For example,
  ///  `projects/example-project/locations/us-central1/registries/my-registry`.
  /// @param update_mask  Required. Only updates the `device_registry` fields
  /// indicated by this mask.
  ///  The field mask must not be empty, and it must not contain fields that
  ///  are immutable or only set by the server.
  ///  Mutable top-level fields: `event_notification_config`, `http_config`,
  ///  `mqtt_config`, and `state_notification_config`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::DeviceRegistry,google/cloud/iot/v1/resources.proto#L155}
  ///
  /// [google.cloud.iot.v1.UpdateDeviceRegistryRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L315}
  /// [google.cloud.iot.v1.DeviceRegistry]:
  /// @googleapis_reference_link{google/cloud/iot/v1/resources.proto#L155}
  ///
  StatusOr<google::cloud::iot::v1::DeviceRegistry> UpdateDeviceRegistry(
      google::cloud::iot::v1::DeviceRegistry const& device_registry,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates a device registry configuration.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::iot::v1::UpdateDeviceRegistryRequest,google/cloud/iot/v1/device_manager.proto#L315}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::DeviceRegistry,google/cloud/iot/v1/resources.proto#L155}
  ///
  /// [google.cloud.iot.v1.UpdateDeviceRegistryRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L315}
  /// [google.cloud.iot.v1.DeviceRegistry]:
  /// @googleapis_reference_link{google/cloud/iot/v1/resources.proto#L155}
  ///
  StatusOr<google::cloud::iot::v1::DeviceRegistry> UpdateDeviceRegistry(
      google::cloud::iot::v1::UpdateDeviceRegistryRequest const& request,
      Options options = {});

  ///
  /// Deletes a device registry configuration.
  ///
  /// @param name  Required. The name of the device registry. For example,
  ///  `projects/example-project/locations/us-central1/registries/my-registry`.
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.iot.v1.DeleteDeviceRegistryRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L303}
  ///
  Status DeleteDeviceRegistry(std::string const& name, Options options = {});

  ///
  /// Deletes a device registry configuration.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::iot::v1::DeleteDeviceRegistryRequest,google/cloud/iot/v1/device_manager.proto#L303}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.iot.v1.DeleteDeviceRegistryRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L303}
  ///
  Status DeleteDeviceRegistry(
      google::cloud::iot::v1::DeleteDeviceRegistryRequest const& request,
      Options options = {});

  ///
  /// Lists device registries.
  ///
  /// @param parent  Required. The project and cloud region path. For example,
  ///  `projects/example-project/locations/us-central1`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::DeviceRegistry,google/cloud/iot/v1/resources.proto#L155}
  ///
  /// [google.cloud.iot.v1.ListDeviceRegistriesRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L330}
  /// [google.cloud.iot.v1.DeviceRegistry]:
  /// @googleapis_reference_link{google/cloud/iot/v1/resources.proto#L155}
  ///
  StreamRange<google::cloud::iot::v1::DeviceRegistry> ListDeviceRegistries(
      std::string const& parent, Options options = {});

  ///
  /// Lists device registries.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::iot::v1::ListDeviceRegistriesRequest,google/cloud/iot/v1/device_manager.proto#L330}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::DeviceRegistry,google/cloud/iot/v1/resources.proto#L155}
  ///
  /// [google.cloud.iot.v1.ListDeviceRegistriesRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L330}
  /// [google.cloud.iot.v1.DeviceRegistry]:
  /// @googleapis_reference_link{google/cloud/iot/v1/resources.proto#L155}
  ///
  StreamRange<google::cloud::iot::v1::DeviceRegistry> ListDeviceRegistries(
      google::cloud::iot::v1::ListDeviceRegistriesRequest request,
      Options options = {});

  ///
  /// Creates a device in a device registry.
  ///
  /// @param parent  Required. The name of the device registry where this device
  /// should be created.
  ///  For example,
  ///  `projects/example-project/locations/us-central1/registries/my-registry`.
  /// @param device  Required. The device registration details. The field `name`
  /// must be empty. The server
  ///  generates `name` from the device registry `id` and the
  ///  `parent` field.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::Device,google/cloud/iot/v1/resources.proto#L30}
  ///
  /// [google.cloud.iot.v1.CreateDeviceRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L364}
  /// [google.cloud.iot.v1.Device]:
  /// @googleapis_reference_link{google/cloud/iot/v1/resources.proto#L30}
  ///
  StatusOr<google::cloud::iot::v1::Device> CreateDevice(
      std::string const& parent, google::cloud::iot::v1::Device const& device,
      Options options = {});

  ///
  /// Creates a device in a device registry.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::iot::v1::CreateDeviceRequest,google/cloud/iot/v1/device_manager.proto#L364}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::Device,google/cloud/iot/v1/resources.proto#L30}
  ///
  /// [google.cloud.iot.v1.CreateDeviceRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L364}
  /// [google.cloud.iot.v1.Device]:
  /// @googleapis_reference_link{google/cloud/iot/v1/resources.proto#L30}
  ///
  StatusOr<google::cloud::iot::v1::Device> CreateDevice(
      google::cloud::iot::v1::CreateDeviceRequest const& request,
      Options options = {});

  ///
  /// Gets details about a device.
  ///
  /// @param name  Required. The name of the device. For example,
  ///  `projects/p0/locations/us-central1/registries/registry0/devices/device0`
  ///  or
  ///  `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::Device,google/cloud/iot/v1/resources.proto#L30}
  ///
  /// [google.cloud.iot.v1.GetDeviceRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L382}
  /// [google.cloud.iot.v1.Device]:
  /// @googleapis_reference_link{google/cloud/iot/v1/resources.proto#L30}
  ///
  StatusOr<google::cloud::iot::v1::Device> GetDevice(std::string const& name,
                                                     Options options = {});

  ///
  /// Gets details about a device.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::iot::v1::GetDeviceRequest,google/cloud/iot/v1/device_manager.proto#L382}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::Device,google/cloud/iot/v1/resources.proto#L30}
  ///
  /// [google.cloud.iot.v1.GetDeviceRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L382}
  /// [google.cloud.iot.v1.Device]:
  /// @googleapis_reference_link{google/cloud/iot/v1/resources.proto#L30}
  ///
  StatusOr<google::cloud::iot::v1::Device> GetDevice(
      google::cloud::iot::v1::GetDeviceRequest const& request,
      Options options = {});

  ///
  /// Updates a device.
  ///
  /// @param device  Required. The new values for the device. The `id` and
  /// `num_id` fields must
  ///  be empty, and the field `name` must specify the name path. For example,
  ///  `projects/p0/locations/us-central1/registries/registry0/devices/device0`or
  ///  `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
  /// @param update_mask  Required. Only updates the `device` fields indicated
  /// by this mask.
  ///  The field mask must not be empty, and it must not contain fields that
  ///  are immutable or only set by the server.
  ///  Mutable top-level fields: `credentials`, `blocked`, and `metadata`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::Device,google/cloud/iot/v1/resources.proto#L30}
  ///
  /// [google.cloud.iot.v1.UpdateDeviceRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L400}
  /// [google.cloud.iot.v1.Device]:
  /// @googleapis_reference_link{google/cloud/iot/v1/resources.proto#L30}
  ///
  StatusOr<google::cloud::iot::v1::Device> UpdateDevice(
      google::cloud::iot::v1::Device const& device,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates a device.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::iot::v1::UpdateDeviceRequest,google/cloud/iot/v1/device_manager.proto#L400}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::Device,google/cloud/iot/v1/resources.proto#L30}
  ///
  /// [google.cloud.iot.v1.UpdateDeviceRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L400}
  /// [google.cloud.iot.v1.Device]:
  /// @googleapis_reference_link{google/cloud/iot/v1/resources.proto#L30}
  ///
  StatusOr<google::cloud::iot::v1::Device> UpdateDevice(
      google::cloud::iot::v1::UpdateDeviceRequest const& request,
      Options options = {});

  ///
  /// Deletes a device.
  ///
  /// @param name  Required. The name of the device. For example,
  ///  `projects/p0/locations/us-central1/registries/registry0/devices/device0`
  ///  or
  ///  `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.iot.v1.DeleteDeviceRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L415}
  ///
  Status DeleteDevice(std::string const& name, Options options = {});

  ///
  /// Deletes a device.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::iot::v1::DeleteDeviceRequest,google/cloud/iot/v1/device_manager.proto#L415}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.iot.v1.DeleteDeviceRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L415}
  ///
  Status DeleteDevice(
      google::cloud::iot::v1::DeleteDeviceRequest const& request,
      Options options = {});

  ///
  /// List devices in a device registry.
  ///
  /// @param parent  Required. The device registry path. Required. For example,
  ///  `projects/my-project/locations/us-central1/registries/my-registry`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::Device,google/cloud/iot/v1/resources.proto#L30}
  ///
  /// [google.cloud.iot.v1.ListDevicesRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L428}
  /// [google.cloud.iot.v1.Device]:
  /// @googleapis_reference_link{google/cloud/iot/v1/resources.proto#L30}
  ///
  StreamRange<google::cloud::iot::v1::Device> ListDevices(
      std::string const& parent, Options options = {});

  ///
  /// List devices in a device registry.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::iot::v1::ListDevicesRequest,google/cloud/iot/v1/device_manager.proto#L428}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::Device,google/cloud/iot/v1/resources.proto#L30}
  ///
  /// [google.cloud.iot.v1.ListDevicesRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L428}
  /// [google.cloud.iot.v1.Device]:
  /// @googleapis_reference_link{google/cloud/iot/v1/resources.proto#L30}
  ///
  StreamRange<google::cloud::iot::v1::Device> ListDevices(
      google::cloud::iot::v1::ListDevicesRequest request, Options options = {});

  ///
  /// Modifies the configuration for the device, which is eventually sent from
  /// the Cloud IoT Core servers. Returns the modified configuration version and
  /// its metadata.
  ///
  /// @param name  Required. The name of the device. For example,
  ///  `projects/p0/locations/us-central1/registries/registry0/devices/device0`
  ///  or
  ///  `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
  /// @param binary_data  Required. The configuration data for the device.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::DeviceConfig,google/cloud/iot/v1/resources.proto#L449}
  ///
  /// [google.cloud.iot.v1.ModifyCloudToDeviceConfigRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L502}
  /// [google.cloud.iot.v1.DeviceConfig]:
  /// @googleapis_reference_link{google/cloud/iot/v1/resources.proto#L449}
  ///
  StatusOr<google::cloud::iot::v1::DeviceConfig> ModifyCloudToDeviceConfig(
      std::string const& name, std::string const& binary_data,
      Options options = {});

  ///
  /// Modifies the configuration for the device, which is eventually sent from
  /// the Cloud IoT Core servers. Returns the modified configuration version and
  /// its metadata.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::iot::v1::ModifyCloudToDeviceConfigRequest,google/cloud/iot/v1/device_manager.proto#L502}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::DeviceConfig,google/cloud/iot/v1/resources.proto#L449}
  ///
  /// [google.cloud.iot.v1.ModifyCloudToDeviceConfigRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L502}
  /// [google.cloud.iot.v1.DeviceConfig]:
  /// @googleapis_reference_link{google/cloud/iot/v1/resources.proto#L449}
  ///
  StatusOr<google::cloud::iot::v1::DeviceConfig> ModifyCloudToDeviceConfig(
      google::cloud::iot::v1::ModifyCloudToDeviceConfigRequest const& request,
      Options options = {});

  ///
  /// Lists the last few versions of the device configuration in descending
  /// order (i.e.: newest first).
  ///
  /// @param name  Required. The name of the device. For example,
  ///  `projects/p0/locations/us-central1/registries/registry0/devices/device0`
  ///  or
  ///  `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::ListDeviceConfigVersionsResponse,google/cloud/iot/v1/device_manager.proto#L543}
  ///
  /// [google.cloud.iot.v1.ListDeviceConfigVersionsRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L525}
  /// [google.cloud.iot.v1.ListDeviceConfigVersionsResponse]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L543}
  ///
  StatusOr<google::cloud::iot::v1::ListDeviceConfigVersionsResponse>
  ListDeviceConfigVersions(std::string const& name, Options options = {});

  ///
  /// Lists the last few versions of the device configuration in descending
  /// order (i.e.: newest first).
  ///
  /// @param request
  /// @googleapis_link{google::cloud::iot::v1::ListDeviceConfigVersionsRequest,google/cloud/iot/v1/device_manager.proto#L525}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::ListDeviceConfigVersionsResponse,google/cloud/iot/v1/device_manager.proto#L543}
  ///
  /// [google.cloud.iot.v1.ListDeviceConfigVersionsRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L525}
  /// [google.cloud.iot.v1.ListDeviceConfigVersionsResponse]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L543}
  ///
  StatusOr<google::cloud::iot::v1::ListDeviceConfigVersionsResponse>
  ListDeviceConfigVersions(
      google::cloud::iot::v1::ListDeviceConfigVersionsRequest const& request,
      Options options = {});

  ///
  /// Lists the last few versions of the device state in descending order (i.e.:
  /// newest first).
  ///
  /// @param name  Required. The name of the device. For example,
  ///  `projects/p0/locations/us-central1/registries/registry0/devices/device0`
  ///  or
  ///  `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::ListDeviceStatesResponse,google/cloud/iot/v1/device_manager.proto#L568}
  ///
  /// [google.cloud.iot.v1.ListDeviceStatesRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L550}
  /// [google.cloud.iot.v1.ListDeviceStatesResponse]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L568}
  ///
  StatusOr<google::cloud::iot::v1::ListDeviceStatesResponse> ListDeviceStates(
      std::string const& name, Options options = {});

  ///
  /// Lists the last few versions of the device state in descending order (i.e.:
  /// newest first).
  ///
  /// @param request
  /// @googleapis_link{google::cloud::iot::v1::ListDeviceStatesRequest,google/cloud/iot/v1/device_manager.proto#L550}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::ListDeviceStatesResponse,google/cloud/iot/v1/device_manager.proto#L568}
  ///
  /// [google.cloud.iot.v1.ListDeviceStatesRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L550}
  /// [google.cloud.iot.v1.ListDeviceStatesResponse]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L568}
  ///
  StatusOr<google::cloud::iot::v1::ListDeviceStatesResponse> ListDeviceStates(
      google::cloud::iot::v1::ListDeviceStatesRequest const& request,
      Options options = {});

  ///
  /// Sets the access control policy on the specified resource. Replaces any
  /// existing policy.
  ///
  /// @param resource  REQUIRED: The resource for which the policy is being
  /// specified.
  ///  See the operation documentation for the appropriate value for this field.
  /// @param policy  REQUIRED: The complete policy to be applied to the
  /// `resource`. The size of
  ///  the policy is limited to a few 10s of KB. An empty policy is a
  ///  valid policy but certain Cloud Platform services (such as Projects)
  ///  might reject them.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::Policy,google/iam/v1/policy.proto#L88}
  ///
  /// [google.iam.v1.SetIamPolicyRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L98}
  /// [google.iam.v1.Policy]:
  /// @googleapis_reference_link{google/iam/v1/policy.proto#L88}
  ///
  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      std::string const& resource, google::iam::v1::Policy const& policy,
      Options options = {});

  /**
   * Updates the IAM policy for @p resource using an optimistic concurrency
   * control loop.
   *
   * The loop fetches the current policy for @p resource, and passes it to @p
   * updater, which should return the new policy. This new policy should use the
   * current etag so that the read-modify-write cycle can detect races and rerun
   * the update when there is a mismatch. If the new policy does not have an
   * etag, the existing policy will be blindly overwritten. If @p updater does
   * not yield a policy, the control loop is terminated and kCancelled is
   * returned.
   *
   * @param resource  Required. The resource for which the policy is being
   * specified. See the operation documentation for the appropriate value for
   * this field.
   * @param updater  Required. Functor to map the current policy to a new one.
   * @param options  Optional. Options to control the loop. Expected options
   * are:
   *       - `DeviceManagerBackoffPolicyOption`
   * @return google::iam::v1::Policy
   */
  StatusOr<google::iam::v1::Policy> SetIamPolicy(std::string const& resource,
                                                 IamUpdater const& updater,
                                                 Options options = {});

  ///
  /// Sets the access control policy on the specified resource. Replaces any
  /// existing policy.
  ///
  /// @param request
  /// @googleapis_link{google::iam::v1::SetIamPolicyRequest,google/iam/v1/iam_policy.proto#L98}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::Policy,google/iam/v1/policy.proto#L88}
  ///
  /// [google.iam.v1.SetIamPolicyRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L98}
  /// [google.iam.v1.Policy]:
  /// @googleapis_reference_link{google/iam/v1/policy.proto#L88}
  ///
  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request,
      Options options = {});

  ///
  /// Gets the access control policy for a resource.
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// @param resource  REQUIRED: The resource for which the policy is being
  /// requested.
  ///  See the operation documentation for the appropriate value for this field.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::Policy,google/iam/v1/policy.proto#L88}
  ///
  /// [google.iam.v1.GetIamPolicyRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L113}
  /// [google.iam.v1.Policy]:
  /// @googleapis_reference_link{google/iam/v1/policy.proto#L88}
  ///
  StatusOr<google::iam::v1::Policy> GetIamPolicy(std::string const& resource,
                                                 Options options = {});

  ///
  /// Gets the access control policy for a resource.
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// @param request
  /// @googleapis_link{google::iam::v1::GetIamPolicyRequest,google/iam/v1/iam_policy.proto#L113}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::Policy,google/iam/v1/policy.proto#L88}
  ///
  /// [google.iam.v1.GetIamPolicyRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L113}
  /// [google.iam.v1.Policy]:
  /// @googleapis_reference_link{google/iam/v1/policy.proto#L88}
  ///
  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request,
      Options options = {});

  ///
  /// Returns permissions that a caller has on the specified resource.
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a NOT_FOUND error.
  ///
  /// @param resource  REQUIRED: The resource for which the policy detail is
  /// being requested.
  ///  See the operation documentation for the appropriate value for this field.
  /// @param permissions  The set of permissions to check for the `resource`.
  /// Permissions with
  ///  wildcards (such as '*' or 'storage.*') are not allowed. For more
  ///  information see
  ///  [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::TestIamPermissionsResponse,google/iam/v1/iam_policy.proto#L141}
  ///
  /// [google.iam.v1.TestIamPermissionsRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L126}
  /// [google.iam.v1.TestIamPermissionsResponse]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L141}
  ///
  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      std::string const& resource, std::vector<std::string> const& permissions,
      Options options = {});

  ///
  /// Returns permissions that a caller has on the specified resource.
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a NOT_FOUND error.
  ///
  /// @param request
  /// @googleapis_link{google::iam::v1::TestIamPermissionsRequest,google/iam/v1/iam_policy.proto#L126}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::TestIamPermissionsResponse,google/iam/v1/iam_policy.proto#L141}
  ///
  /// [google.iam.v1.TestIamPermissionsRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L126}
  /// [google.iam.v1.TestIamPermissionsResponse]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L141}
  ///
  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request,
      Options options = {});

  ///
  /// Sends a command to the specified device. In order for a device to be able
  /// to receive commands, it must:
  /// 1) be connected to Cloud IoT Core using the MQTT protocol, and
  /// 2) be subscribed to the group of MQTT topics specified by
  ///    /devices/{device-id}/commands/#. This subscription will receive
  ///    commands at the top-level topic /devices/{device-id}/commands as well
  ///    as commands for subfolders, like
  ///    /devices/{device-id}/commands/subfolder. Note that subscribing to
  ///    specific subfolders is not supported.
  /// If the command could not be delivered to the device, this method will
  /// return an error; in particular, if the device is not subscribed, this
  /// method will return FAILED_PRECONDITION. Otherwise, this method will
  /// return OK. If the subscription is QoS 1, at least once delivery will be
  /// guaranteed; for QoS 0, no acknowledgment will be expected from the device.
  ///
  /// @param name  Required. The name of the device. For example,
  ///  `projects/p0/locations/us-central1/registries/registry0/devices/device0`
  ///  or
  ///  `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
  /// @param binary_data  Required. The command data to send to the device.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::SendCommandToDeviceResponse,google/cloud/iot/v1/device_manager.proto#L598}
  ///
  /// [google.cloud.iot.v1.SendCommandToDeviceRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L575}
  /// [google.cloud.iot.v1.SendCommandToDeviceResponse]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L598}
  ///
  StatusOr<google::cloud::iot::v1::SendCommandToDeviceResponse>
  SendCommandToDevice(std::string const& name, std::string const& binary_data,
                      Options options = {});

  ///
  /// Sends a command to the specified device. In order for a device to be able
  /// to receive commands, it must:
  /// 1) be connected to Cloud IoT Core using the MQTT protocol, and
  /// 2) be subscribed to the group of MQTT topics specified by
  ///    /devices/{device-id}/commands/#. This subscription will receive
  ///    commands at the top-level topic /devices/{device-id}/commands as well
  ///    as commands for subfolders, like
  ///    /devices/{device-id}/commands/subfolder. Note that subscribing to
  ///    specific subfolders is not supported.
  /// If the command could not be delivered to the device, this method will
  /// return an error; in particular, if the device is not subscribed, this
  /// method will return FAILED_PRECONDITION. Otherwise, this method will
  /// return OK. If the subscription is QoS 1, at least once delivery will be
  /// guaranteed; for QoS 0, no acknowledgment will be expected from the device.
  ///
  /// @param name  Required. The name of the device. For example,
  ///  `projects/p0/locations/us-central1/registries/registry0/devices/device0`
  ///  or
  ///  `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
  /// @param binary_data  Required. The command data to send to the device.
  /// @param subfolder  Optional subfolder for the command. If empty, the
  /// command will be delivered
  ///  to the /devices/{device-id}/commands topic, otherwise it will be
  ///  delivered to the /devices/{device-id}/commands/{subfolder} topic.
  ///  Multi-level subfolders are allowed. This field must not have more than
  ///  256 characters, and must not contain any MQTT wildcards ("+" or "#") or
  ///  null characters.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::SendCommandToDeviceResponse,google/cloud/iot/v1/device_manager.proto#L598}
  ///
  /// [google.cloud.iot.v1.SendCommandToDeviceRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L575}
  /// [google.cloud.iot.v1.SendCommandToDeviceResponse]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L598}
  ///
  StatusOr<google::cloud::iot::v1::SendCommandToDeviceResponse>
  SendCommandToDevice(std::string const& name, std::string const& binary_data,
                      std::string const& subfolder, Options options = {});

  ///
  /// Sends a command to the specified device. In order for a device to be able
  /// to receive commands, it must:
  /// 1) be connected to Cloud IoT Core using the MQTT protocol, and
  /// 2) be subscribed to the group of MQTT topics specified by
  ///    /devices/{device-id}/commands/#. This subscription will receive
  ///    commands at the top-level topic /devices/{device-id}/commands as well
  ///    as commands for subfolders, like
  ///    /devices/{device-id}/commands/subfolder. Note that subscribing to
  ///    specific subfolders is not supported.
  /// If the command could not be delivered to the device, this method will
  /// return an error; in particular, if the device is not subscribed, this
  /// method will return FAILED_PRECONDITION. Otherwise, this method will
  /// return OK. If the subscription is QoS 1, at least once delivery will be
  /// guaranteed; for QoS 0, no acknowledgment will be expected from the device.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::iot::v1::SendCommandToDeviceRequest,google/cloud/iot/v1/device_manager.proto#L575}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::SendCommandToDeviceResponse,google/cloud/iot/v1/device_manager.proto#L598}
  ///
  /// [google.cloud.iot.v1.SendCommandToDeviceRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L575}
  /// [google.cloud.iot.v1.SendCommandToDeviceResponse]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L598}
  ///
  StatusOr<google::cloud::iot::v1::SendCommandToDeviceResponse>
  SendCommandToDevice(
      google::cloud::iot::v1::SendCommandToDeviceRequest const& request,
      Options options = {});

  ///
  /// Associates the device with the gateway.
  ///
  /// @param parent  Required. The name of the registry. For example,
  ///  `projects/example-project/locations/us-central1/registries/my-registry`.
  /// @param gateway_id  Required. The value of `gateway_id` can be either the
  /// device numeric ID or the
  ///  user-defined device identifier.
  /// @param device_id  Required. The device to associate with the specified
  /// gateway. The value of
  ///  `device_id` can be either the device numeric ID or the user-defined
  ///  device identifier.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::BindDeviceToGatewayResponse,google/cloud/iot/v1/device_manager.proto#L624}
  ///
  /// [google.cloud.iot.v1.BindDeviceToGatewayRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L603}
  /// [google.cloud.iot.v1.BindDeviceToGatewayResponse]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L624}
  ///
  StatusOr<google::cloud::iot::v1::BindDeviceToGatewayResponse>
  BindDeviceToGateway(std::string const& parent, std::string const& gateway_id,
                      std::string const& device_id, Options options = {});

  ///
  /// Associates the device with the gateway.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::iot::v1::BindDeviceToGatewayRequest,google/cloud/iot/v1/device_manager.proto#L603}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::BindDeviceToGatewayResponse,google/cloud/iot/v1/device_manager.proto#L624}
  ///
  /// [google.cloud.iot.v1.BindDeviceToGatewayRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L603}
  /// [google.cloud.iot.v1.BindDeviceToGatewayResponse]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L624}
  ///
  StatusOr<google::cloud::iot::v1::BindDeviceToGatewayResponse>
  BindDeviceToGateway(
      google::cloud::iot::v1::BindDeviceToGatewayRequest const& request,
      Options options = {});

  ///
  /// Deletes the association between the device and the gateway.
  ///
  /// @param parent  Required. The name of the registry. For example,
  ///  `projects/example-project/locations/us-central1/registries/my-registry`.
  /// @param gateway_id  Required. The value of `gateway_id` can be either the
  /// device numeric ID or the
  ///  user-defined device identifier.
  /// @param device_id  Required. The device to disassociate from the specified
  /// gateway. The value of
  ///  `device_id` can be either the device numeric ID or the user-defined
  ///  device identifier.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::UnbindDeviceFromGatewayResponse,google/cloud/iot/v1/device_manager.proto#L650}
  ///
  /// [google.cloud.iot.v1.UnbindDeviceFromGatewayRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L629}
  /// [google.cloud.iot.v1.UnbindDeviceFromGatewayResponse]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L650}
  ///
  StatusOr<google::cloud::iot::v1::UnbindDeviceFromGatewayResponse>
  UnbindDeviceFromGateway(std::string const& parent,
                          std::string const& gateway_id,
                          std::string const& device_id, Options options = {});

  ///
  /// Deletes the association between the device and the gateway.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::iot::v1::UnbindDeviceFromGatewayRequest,google/cloud/iot/v1/device_manager.proto#L629}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::iot::v1::UnbindDeviceFromGatewayResponse,google/cloud/iot/v1/device_manager.proto#L650}
  ///
  /// [google.cloud.iot.v1.UnbindDeviceFromGatewayRequest]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L629}
  /// [google.cloud.iot.v1.UnbindDeviceFromGatewayResponse]:
  /// @googleapis_reference_link{google/cloud/iot/v1/device_manager.proto#L650}
  ///
  StatusOr<google::cloud::iot::v1::UnbindDeviceFromGatewayResponse>
  UnbindDeviceFromGateway(
      google::cloud::iot::v1::UnbindDeviceFromGatewayRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<DeviceManagerConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iot
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_IOT_DEVICE_MANAGER_CLIENT_H
