// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/iot/v1/device_manager.proto

#include "google/cloud/iot/device_manager_client.h"
#include "google/cloud/iot/device_manager_options.h"
#include "google/cloud/iot/internal/device_manager_option_defaults.h"
#include <memory>
#include <thread>

namespace google {
namespace cloud {
namespace iot {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DeviceManagerClient::DeviceManagerClient(
    std::shared_ptr<DeviceManagerConnection> connection, Options options)
    : connection_(std::move(connection)),
      options_(internal::MergeOptions(
          std::move(options),
          iot_internal::DeviceManagerDefaultOptions(connection_->options()))) {}
DeviceManagerClient::~DeviceManagerClient() = default;

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerClient::CreateDeviceRegistry(
    std::string const& parent,
    google::cloud::iot::v1::DeviceRegistry const& device_registry,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::iot::v1::CreateDeviceRegistryRequest request;
  request.set_parent(parent);
  *request.mutable_device_registry() = device_registry;
  return connection_->CreateDeviceRegistry(request);
}

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerClient::CreateDeviceRegistry(
    google::cloud::iot::v1::CreateDeviceRegistryRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CreateDeviceRegistry(request);
}

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerClient::GetDeviceRegistry(std::string const& name,
                                       Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::iot::v1::GetDeviceRegistryRequest request;
  request.set_name(name);
  return connection_->GetDeviceRegistry(request);
}

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerClient::GetDeviceRegistry(
    google::cloud::iot::v1::GetDeviceRegistryRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetDeviceRegistry(request);
}

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerClient::UpdateDeviceRegistry(
    google::cloud::iot::v1::DeviceRegistry const& device_registry,
    google::protobuf::FieldMask const& update_mask, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::iot::v1::UpdateDeviceRegistryRequest request;
  *request.mutable_device_registry() = device_registry;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDeviceRegistry(request);
}

StatusOr<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerClient::UpdateDeviceRegistry(
    google::cloud::iot::v1::UpdateDeviceRegistryRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdateDeviceRegistry(request);
}

Status DeviceManagerClient::DeleteDeviceRegistry(std::string const& name,
                                                 Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::iot::v1::DeleteDeviceRegistryRequest request;
  request.set_name(name);
  return connection_->DeleteDeviceRegistry(request);
}

Status DeviceManagerClient::DeleteDeviceRegistry(
    google::cloud::iot::v1::DeleteDeviceRegistryRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeleteDeviceRegistry(request);
}

StreamRange<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerClient::ListDeviceRegistries(std::string const& parent,
                                          Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::iot::v1::ListDeviceRegistriesRequest request;
  request.set_parent(parent);
  return connection_->ListDeviceRegistries(request);
}

StreamRange<google::cloud::iot::v1::DeviceRegistry>
DeviceManagerClient::ListDeviceRegistries(
    google::cloud::iot::v1::ListDeviceRegistriesRequest request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListDeviceRegistries(std::move(request));
}

StatusOr<google::cloud::iot::v1::Device> DeviceManagerClient::CreateDevice(
    std::string const& parent, google::cloud::iot::v1::Device const& device,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::iot::v1::CreateDeviceRequest request;
  request.set_parent(parent);
  *request.mutable_device() = device;
  return connection_->CreateDevice(request);
}

StatusOr<google::cloud::iot::v1::Device> DeviceManagerClient::CreateDevice(
    google::cloud::iot::v1::CreateDeviceRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CreateDevice(request);
}

StatusOr<google::cloud::iot::v1::Device> DeviceManagerClient::GetDevice(
    std::string const& name, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::iot::v1::GetDeviceRequest request;
  request.set_name(name);
  return connection_->GetDevice(request);
}

StatusOr<google::cloud::iot::v1::Device> DeviceManagerClient::GetDevice(
    google::cloud::iot::v1::GetDeviceRequest const& request, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetDevice(request);
}

StatusOr<google::cloud::iot::v1::Device> DeviceManagerClient::UpdateDevice(
    google::cloud::iot::v1::Device const& device,
    google::protobuf::FieldMask const& update_mask, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::iot::v1::UpdateDeviceRequest request;
  *request.mutable_device() = device;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDevice(request);
}

StatusOr<google::cloud::iot::v1::Device> DeviceManagerClient::UpdateDevice(
    google::cloud::iot::v1::UpdateDeviceRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdateDevice(request);
}

Status DeviceManagerClient::DeleteDevice(std::string const& name,
                                         Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::iot::v1::DeleteDeviceRequest request;
  request.set_name(name);
  return connection_->DeleteDevice(request);
}

Status DeviceManagerClient::DeleteDevice(
    google::cloud::iot::v1::DeleteDeviceRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeleteDevice(request);
}

StreamRange<google::cloud::iot::v1::Device> DeviceManagerClient::ListDevices(
    std::string const& parent, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::iot::v1::ListDevicesRequest request;
  request.set_parent(parent);
  return connection_->ListDevices(request);
}

StreamRange<google::cloud::iot::v1::Device> DeviceManagerClient::ListDevices(
    google::cloud::iot::v1::ListDevicesRequest request, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListDevices(std::move(request));
}

StatusOr<google::cloud::iot::v1::DeviceConfig>
DeviceManagerClient::ModifyCloudToDeviceConfig(std::string const& name,
                                               std::string const& binary_data,
                                               Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::iot::v1::ModifyCloudToDeviceConfigRequest request;
  request.set_name(name);
  request.set_binary_data(binary_data);
  return connection_->ModifyCloudToDeviceConfig(request);
}

StatusOr<google::cloud::iot::v1::DeviceConfig>
DeviceManagerClient::ModifyCloudToDeviceConfig(
    google::cloud::iot::v1::ModifyCloudToDeviceConfigRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ModifyCloudToDeviceConfig(request);
}

StatusOr<google::cloud::iot::v1::ListDeviceConfigVersionsResponse>
DeviceManagerClient::ListDeviceConfigVersions(std::string const& name,
                                              Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::iot::v1::ListDeviceConfigVersionsRequest request;
  request.set_name(name);
  return connection_->ListDeviceConfigVersions(request);
}

StatusOr<google::cloud::iot::v1::ListDeviceConfigVersionsResponse>
DeviceManagerClient::ListDeviceConfigVersions(
    google::cloud::iot::v1::ListDeviceConfigVersionsRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListDeviceConfigVersions(request);
}

StatusOr<google::cloud::iot::v1::ListDeviceStatesResponse>
DeviceManagerClient::ListDeviceStates(std::string const& name,
                                      Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::iot::v1::ListDeviceStatesRequest request;
  request.set_name(name);
  return connection_->ListDeviceStates(request);
}

StatusOr<google::cloud::iot::v1::ListDeviceStatesResponse>
DeviceManagerClient::ListDeviceStates(
    google::cloud::iot::v1::ListDeviceStatesRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListDeviceStates(request);
}

StatusOr<google::iam::v1::Policy> DeviceManagerClient::SetIamPolicy(
    std::string const& resource, google::iam::v1::Policy const& policy,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::iam::v1::SetIamPolicyRequest request;
  request.set_resource(resource);
  *request.mutable_policy() = policy;
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> DeviceManagerClient::SetIamPolicy(
    std::string const& resource, IamUpdater const& updater, Options options) {
  internal::CheckExpectedOptions<DeviceManagerBackoffPolicyOption>(options,
                                                                   __func__);
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::iam::v1::GetIamPolicyRequest get_request;
  get_request.set_resource(resource);
  google::iam::v1::SetIamPolicyRequest set_request;
  set_request.set_resource(resource);
  auto backoff_policy = internal::CurrentOptions()
                            .get<DeviceManagerBackoffPolicyOption>()
                            ->clone();
  for (;;) {
    auto recent = connection_->GetIamPolicy(get_request);
    if (!recent) {
      return recent.status();
    }
    auto policy = updater(*std::move(recent));
    if (!policy) {
      return Status(StatusCode::kCancelled, "updater did not yield a policy");
    }
    *set_request.mutable_policy() = *std::move(policy);
    auto result = connection_->SetIamPolicy(set_request);
    if (result || result.status().code() != StatusCode::kAborted) {
      return result;
    }
    std::this_thread::sleep_for(backoff_policy->OnCompletion());
  }
}

StatusOr<google::iam::v1::Policy> DeviceManagerClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> DeviceManagerClient::GetIamPolicy(
    std::string const& resource, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::iam::v1::GetIamPolicyRequest request;
  request.set_resource(resource);
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> DeviceManagerClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DeviceManagerClient::TestIamPermissions(
    std::string const& resource, std::vector<std::string> const& permissions,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::iam::v1::TestIamPermissionsRequest request;
  request.set_resource(resource);
  *request.mutable_permissions() = {permissions.begin(), permissions.end()};
  return connection_->TestIamPermissions(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DeviceManagerClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->TestIamPermissions(request);
}

StatusOr<google::cloud::iot::v1::SendCommandToDeviceResponse>
DeviceManagerClient::SendCommandToDevice(std::string const& name,
                                         std::string const& binary_data,
                                         Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::iot::v1::SendCommandToDeviceRequest request;
  request.set_name(name);
  request.set_binary_data(binary_data);
  return connection_->SendCommandToDevice(request);
}

StatusOr<google::cloud::iot::v1::SendCommandToDeviceResponse>
DeviceManagerClient::SendCommandToDevice(std::string const& name,
                                         std::string const& binary_data,
                                         std::string const& subfolder,
                                         Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::iot::v1::SendCommandToDeviceRequest request;
  request.set_name(name);
  request.set_binary_data(binary_data);
  request.set_subfolder(subfolder);
  return connection_->SendCommandToDevice(request);
}

StatusOr<google::cloud::iot::v1::SendCommandToDeviceResponse>
DeviceManagerClient::SendCommandToDevice(
    google::cloud::iot::v1::SendCommandToDeviceRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->SendCommandToDevice(request);
}

StatusOr<google::cloud::iot::v1::BindDeviceToGatewayResponse>
DeviceManagerClient::BindDeviceToGateway(std::string const& parent,
                                         std::string const& gateway_id,
                                         std::string const& device_id,
                                         Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::iot::v1::BindDeviceToGatewayRequest request;
  request.set_parent(parent);
  request.set_gateway_id(gateway_id);
  request.set_device_id(device_id);
  return connection_->BindDeviceToGateway(request);
}

StatusOr<google::cloud::iot::v1::BindDeviceToGatewayResponse>
DeviceManagerClient::BindDeviceToGateway(
    google::cloud::iot::v1::BindDeviceToGatewayRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->BindDeviceToGateway(request);
}

StatusOr<google::cloud::iot::v1::UnbindDeviceFromGatewayResponse>
DeviceManagerClient::UnbindDeviceFromGateway(std::string const& parent,
                                             std::string const& gateway_id,
                                             std::string const& device_id,
                                             Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::iot::v1::UnbindDeviceFromGatewayRequest request;
  request.set_parent(parent);
  request.set_gateway_id(gateway_id);
  request.set_device_id(device_id);
  return connection_->UnbindDeviceFromGateway(request);
}

StatusOr<google::cloud::iot::v1::UnbindDeviceFromGatewayResponse>
DeviceManagerClient::UnbindDeviceFromGateway(
    google::cloud::iot::v1::UnbindDeviceFromGatewayRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UnbindDeviceFromGateway(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iot
}  // namespace cloud
}  // namespace google
