// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/ids/v1/ids.proto

#include "google/cloud/ids/internal/ids_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/cloud/ids/v1/ids.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace ids_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

IDSMetadata::IDSMetadata(std::shared_ptr<IDSStub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::cloud::ids::v1::ListEndpointsResponse>
IDSMetadata::ListEndpoints(
    grpc::ClientContext& context,
    google::cloud::ids::v1::ListEndpointsRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListEndpoints(context, request);
}

StatusOr<google::cloud::ids::v1::Endpoint> IDSMetadata::GetEndpoint(
    grpc::ClientContext& context,
    google::cloud::ids::v1::GetEndpointRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetEndpoint(context, request);
}

future<StatusOr<google::longrunning::Operation>>
IDSMetadata::AsyncCreateEndpoint(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::ids::v1::CreateEndpointRequest const& request) {
  SetMetadata(*context, "parent=" + request.parent());
  return child_->AsyncCreateEndpoint(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
IDSMetadata::AsyncDeleteEndpoint(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::ids::v1::DeleteEndpointRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncDeleteEndpoint(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>> IDSMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncGetOperation(cq, std::move(context), request);
}

future<Status> IDSMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncCancelOperation(cq, std::move(context), request);
}

void IDSMetadata::SetMetadata(grpc::ClientContext& context,
                              std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void IDSMetadata::SetMetadata(grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace ids_internal
}  // namespace cloud
}  // namespace google
