// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/ids/v1/ids.proto

#include "google/cloud/ids/ids_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace ids {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

IDSConnectionIdempotencyPolicy::~IDSConnectionIdempotencyPolicy() = default;

namespace {
class DefaultIDSConnectionIdempotencyPolicy
    : public IDSConnectionIdempotencyPolicy {
 public:
  ~DefaultIDSConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<IDSConnectionIdempotencyPolicy> clone() const override {
    return absl::make_unique<DefaultIDSConnectionIdempotencyPolicy>(*this);
  }

  Idempotency ListEndpoints(
      google::cloud::ids::v1::ListEndpointsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetEndpoint(
      google::cloud::ids::v1::GetEndpointRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateEndpoint(
      google::cloud::ids::v1::CreateEndpointRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteEndpoint(
      google::cloud::ids::v1::DeleteEndpointRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<IDSConnectionIdempotencyPolicy>
MakeDefaultIDSConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultIDSConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace ids
}  // namespace cloud
}  // namespace google
