// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/ids/v1/ids.proto

#include "google/cloud/ids/ids_connection.h"
#include "google/cloud/ids/ids_options.h"
#include "google/cloud/ids/internal/ids_connection_impl.h"
#include "google/cloud/ids/internal/ids_option_defaults.h"
#include "google/cloud/ids/internal/ids_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace ids {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

IDSConnection::~IDSConnection() = default;

StreamRange<google::cloud::ids::v1::Endpoint> IDSConnection::ListEndpoints(
    google::cloud::ids::v1::ListEndpointsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::ids::v1::Endpoint>>(
      std::move(request),
      [](google::cloud::ids::v1::ListEndpointsRequest const&) {
        return StatusOr<google::cloud::ids::v1::ListEndpointsResponse>{};
      },
      [](google::cloud::ids::v1::ListEndpointsResponse const&) {
        return std::vector<google::cloud::ids::v1::Endpoint>();
      });
}

StatusOr<google::cloud::ids::v1::Endpoint> IDSConnection::GetEndpoint(
    google::cloud::ids::v1::GetEndpointRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::ids::v1::Endpoint>>
IDSConnection::CreateEndpoint(
    google::cloud::ids::v1::CreateEndpointRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::ids::v1::Endpoint>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::ids::v1::OperationMetadata>>
IDSConnection::DeleteEndpoint(
    google::cloud::ids::v1::DeleteEndpointRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::ids::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<IDSConnection> MakeIDSConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 IDSPolicyOptionList>(options, __func__);
  options = ids_internal::IDSDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = ids_internal::CreateDefaultIDSStub(background->cq(), options);
  return std::make_shared<ids_internal::IDSConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace ids
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace ids_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<ids::IDSConnection> MakeIDSConnection(
    std::shared_ptr<IDSStub> stub, Options options) {
  options = IDSDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<ids_internal::IDSConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace ids_internal
}  // namespace cloud
}  // namespace google
