// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/iap/v1/service.proto

#include "google/cloud/iap/internal/identity_aware_proxy_o_auth_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/cloud/iap/v1/service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace iap_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

IdentityAwareProxyOAuthServiceMetadata::IdentityAwareProxyOAuthServiceMetadata(
    std::shared_ptr<IdentityAwareProxyOAuthServiceStub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::cloud::iap::v1::ListBrandsResponse>
IdentityAwareProxyOAuthServiceMetadata::ListBrands(
    grpc::ClientContext& context,
    google::cloud::iap::v1::ListBrandsRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListBrands(context, request);
}

StatusOr<google::cloud::iap::v1::Brand>
IdentityAwareProxyOAuthServiceMetadata::CreateBrand(
    grpc::ClientContext& context,
    google::cloud::iap::v1::CreateBrandRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->CreateBrand(context, request);
}

StatusOr<google::cloud::iap::v1::Brand>
IdentityAwareProxyOAuthServiceMetadata::GetBrand(
    grpc::ClientContext& context,
    google::cloud::iap::v1::GetBrandRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetBrand(context, request);
}

StatusOr<google::cloud::iap::v1::IdentityAwareProxyClient>
IdentityAwareProxyOAuthServiceMetadata::CreateIdentityAwareProxyClient(
    grpc::ClientContext& context,
    google::cloud::iap::v1::CreateIdentityAwareProxyClientRequest const&
        request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->CreateIdentityAwareProxyClient(context, request);
}

StatusOr<google::cloud::iap::v1::ListIdentityAwareProxyClientsResponse>
IdentityAwareProxyOAuthServiceMetadata::ListIdentityAwareProxyClients(
    grpc::ClientContext& context,
    google::cloud::iap::v1::ListIdentityAwareProxyClientsRequest const&
        request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListIdentityAwareProxyClients(context, request);
}

StatusOr<google::cloud::iap::v1::IdentityAwareProxyClient>
IdentityAwareProxyOAuthServiceMetadata::GetIdentityAwareProxyClient(
    grpc::ClientContext& context,
    google::cloud::iap::v1::GetIdentityAwareProxyClientRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetIdentityAwareProxyClient(context, request);
}

StatusOr<google::cloud::iap::v1::IdentityAwareProxyClient>
IdentityAwareProxyOAuthServiceMetadata::ResetIdentityAwareProxyClientSecret(
    grpc::ClientContext& context,
    google::cloud::iap::v1::ResetIdentityAwareProxyClientSecretRequest const&
        request) {
  SetMetadata(context, "name=" + request.name());
  return child_->ResetIdentityAwareProxyClientSecret(context, request);
}

Status IdentityAwareProxyOAuthServiceMetadata::DeleteIdentityAwareProxyClient(
    grpc::ClientContext& context,
    google::cloud::iap::v1::DeleteIdentityAwareProxyClientRequest const&
        request) {
  SetMetadata(context, "name=" + request.name());
  return child_->DeleteIdentityAwareProxyClient(context, request);
}

void IdentityAwareProxyOAuthServiceMetadata::SetMetadata(
    grpc::ClientContext& context, std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void IdentityAwareProxyOAuthServiceMetadata::SetMetadata(
    grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iap_internal
}  // namespace cloud
}  // namespace google
