// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/iap/v1/service.proto

#include "google/cloud/iap/identity_aware_proxy_o_auth_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace iap {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

IdentityAwareProxyOAuthServiceConnectionIdempotencyPolicy::
    ~IdentityAwareProxyOAuthServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultIdentityAwareProxyOAuthServiceConnectionIdempotencyPolicy
    : public IdentityAwareProxyOAuthServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultIdentityAwareProxyOAuthServiceConnectionIdempotencyPolicy() override =
      default;

  /// Create a new copy of this object.
  std::unique_ptr<IdentityAwareProxyOAuthServiceConnectionIdempotencyPolicy>
  clone() const override {
    return absl::make_unique<
        DefaultIdentityAwareProxyOAuthServiceConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency ListBrands(
      google::cloud::iap::v1::ListBrandsRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateBrand(
      google::cloud::iap::v1::CreateBrandRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetBrand(
      google::cloud::iap::v1::GetBrandRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateIdentityAwareProxyClient(
      google::cloud::iap::v1::CreateIdentityAwareProxyClientRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListIdentityAwareProxyClients(
      google::cloud::iap::v1::ListIdentityAwareProxyClientsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetIdentityAwareProxyClient(
      google::cloud::iap::v1::GetIdentityAwareProxyClientRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency ResetIdentityAwareProxyClientSecret(
      google::cloud::iap::v1::ResetIdentityAwareProxyClientSecretRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteIdentityAwareProxyClient(
      google::cloud::iap::v1::DeleteIdentityAwareProxyClientRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<IdentityAwareProxyOAuthServiceConnectionIdempotencyPolicy>
MakeDefaultIdentityAwareProxyOAuthServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<
      DefaultIdentityAwareProxyOAuthServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iap
}  // namespace cloud
}  // namespace google
