// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/iap/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_IAP_IDENTITY_AWARE_PROXY_O_AUTH_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_IAP_IDENTITY_AWARE_PROXY_O_AUTH_CONNECTION_H

#include "google/cloud/iap/identity_aware_proxy_o_auth_connection_idempotency_policy.h"
#include "google/cloud/iap/internal/identity_aware_proxy_o_auth_retry_traits.h"
#include "google/cloud/iap/internal/identity_aware_proxy_o_auth_stub.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace iap {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using IdentityAwareProxyOAuthServiceRetryPolicy =
    ::google::cloud::internal::TraitBasedRetryPolicy<
        iap_internal::IdentityAwareProxyOAuthServiceRetryTraits>;

using IdentityAwareProxyOAuthServiceLimitedTimeRetryPolicy =
    ::google::cloud::internal::LimitedTimeRetryPolicy<
        iap_internal::IdentityAwareProxyOAuthServiceRetryTraits>;

using IdentityAwareProxyOAuthServiceLimitedErrorCountRetryPolicy =
    ::google::cloud::internal::LimitedErrorCountRetryPolicy<
        iap_internal::IdentityAwareProxyOAuthServiceRetryTraits>;

class IdentityAwareProxyOAuthServiceConnection {
 public:
  virtual ~IdentityAwareProxyOAuthServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<google::cloud::iap::v1::ListBrandsResponse> ListBrands(
      google::cloud::iap::v1::ListBrandsRequest const& request);

  virtual StatusOr<google::cloud::iap::v1::Brand> CreateBrand(
      google::cloud::iap::v1::CreateBrandRequest const& request);

  virtual StatusOr<google::cloud::iap::v1::Brand> GetBrand(
      google::cloud::iap::v1::GetBrandRequest const& request);

  virtual StatusOr<google::cloud::iap::v1::IdentityAwareProxyClient>
  CreateIdentityAwareProxyClient(
      google::cloud::iap::v1::CreateIdentityAwareProxyClientRequest const&
          request);

  virtual StreamRange<google::cloud::iap::v1::IdentityAwareProxyClient>
  ListIdentityAwareProxyClients(
      google::cloud::iap::v1::ListIdentityAwareProxyClientsRequest request);

  virtual StatusOr<google::cloud::iap::v1::IdentityAwareProxyClient>
  GetIdentityAwareProxyClient(
      google::cloud::iap::v1::GetIdentityAwareProxyClientRequest const&
          request);

  virtual StatusOr<google::cloud::iap::v1::IdentityAwareProxyClient>
  ResetIdentityAwareProxyClientSecret(
      google::cloud::iap::v1::ResetIdentityAwareProxyClientSecretRequest const&
          request);

  virtual Status DeleteIdentityAwareProxyClient(
      google::cloud::iap::v1::DeleteIdentityAwareProxyClientRequest const&
          request);
};

std::shared_ptr<IdentityAwareProxyOAuthServiceConnection>
MakeIdentityAwareProxyOAuthServiceConnection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iap
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace iap_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<iap::IdentityAwareProxyOAuthServiceConnection>
MakeIdentityAwareProxyOAuthServiceConnection(
    std::shared_ptr<IdentityAwareProxyOAuthServiceStub> stub, Options options);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iap_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_IAP_IDENTITY_AWARE_PROXY_O_AUTH_CONNECTION_H
