// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/iap/v1/service.proto

#include "google/cloud/iap/identity_aware_proxy_admin_connection.h"
#include "google/cloud/iap/identity_aware_proxy_admin_options.h"
#include "google/cloud/iap/internal/identity_aware_proxy_admin_connection_impl.h"
#include "google/cloud/iap/internal/identity_aware_proxy_admin_option_defaults.h"
#include "google/cloud/iap/internal/identity_aware_proxy_admin_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace iap {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

IdentityAwareProxyAdminServiceConnection::
    ~IdentityAwareProxyAdminServiceConnection() = default;

StatusOr<google::iam::v1::Policy>
IdentityAwareProxyAdminServiceConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy>
IdentityAwareProxyAdminServiceConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
IdentityAwareProxyAdminServiceConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::iap::v1::IapSettings>
IdentityAwareProxyAdminServiceConnection::GetIapSettings(
    google::cloud::iap::v1::GetIapSettingsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::iap::v1::IapSettings>
IdentityAwareProxyAdminServiceConnection::UpdateIapSettings(
    google::cloud::iap::v1::UpdateIapSettingsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<IdentityAwareProxyAdminServiceConnection>
MakeIdentityAwareProxyAdminServiceConnection(Options options) {
  internal::CheckExpectedOptions<
      CommonOptionList, GrpcOptionList,
      IdentityAwareProxyAdminServicePolicyOptionList>(options, __func__);
  options = iap_internal::IdentityAwareProxyAdminServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = iap_internal::CreateDefaultIdentityAwareProxyAdminServiceStub(
      background->cq(), options);
  return std::make_shared<
      iap_internal::IdentityAwareProxyAdminServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iap
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace iap_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<iap::IdentityAwareProxyAdminServiceConnection>
MakeIdentityAwareProxyAdminServiceConnection(
    std::shared_ptr<IdentityAwareProxyAdminServiceStub> stub, Options options) {
  options = IdentityAwareProxyAdminServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<
      iap_internal::IdentityAwareProxyAdminServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iap_internal
}  // namespace cloud
}  // namespace google
