// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/iap/v1/service.proto

#include "google/cloud/iap/identity_aware_proxy_admin_client.h"
#include "google/cloud/iap/internal/identity_aware_proxy_admin_option_defaults.h"
#include <memory>

namespace google {
namespace cloud {
namespace iap {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

IdentityAwareProxyAdminServiceClient::IdentityAwareProxyAdminServiceClient(
    std::shared_ptr<IdentityAwareProxyAdminServiceConnection> connection,
    Options options)
    : connection_(std::move(connection)),
      options_(internal::MergeOptions(
          std::move(options),
          iap_internal::IdentityAwareProxyAdminServiceDefaultOptions(
              connection_->options()))) {}
IdentityAwareProxyAdminServiceClient::~IdentityAwareProxyAdminServiceClient() =
    default;

StatusOr<google::iam::v1::Policy>
IdentityAwareProxyAdminServiceClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy>
IdentityAwareProxyAdminServiceClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
IdentityAwareProxyAdminServiceClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->TestIamPermissions(request);
}

StatusOr<google::cloud::iap::v1::IapSettings>
IdentityAwareProxyAdminServiceClient::GetIapSettings(
    google::cloud::iap::v1::GetIapSettingsRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetIapSettings(request);
}

StatusOr<google::cloud::iap::v1::IapSettings>
IdentityAwareProxyAdminServiceClient::UpdateIapSettings(
    google::cloud::iap::v1::UpdateIapSettingsRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdateIapSettings(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iap
}  // namespace cloud
}  // namespace google
