// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/iam/credentials/v1/iamcredentials.proto

#include "google/cloud/iam/internal/iam_credentials_connection_impl.h"
#include "google/cloud/iam/internal/iam_credentials_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace iam_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

IAMCredentialsConnectionImpl::IAMCredentialsConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<iam_internal::IAMCredentialsStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), iam_internal::IAMCredentialsDefaultOptions(
                                  IAMCredentialsConnection::options()))) {}

StatusOr<google::iam::credentials::v1::GenerateAccessTokenResponse>
IAMCredentialsConnectionImpl::GenerateAccessToken(
    google::iam::credentials::v1::GenerateAccessTokenRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GenerateAccessToken(request),
      [this](grpc::ClientContext& context,
             google::iam::credentials::v1::GenerateAccessTokenRequest const&
                 request) {
        return stub_->GenerateAccessToken(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::credentials::v1::GenerateIdTokenResponse>
IAMCredentialsConnectionImpl::GenerateIdToken(
    google::iam::credentials::v1::GenerateIdTokenRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GenerateIdToken(request),
      [this](
          grpc::ClientContext& context,
          google::iam::credentials::v1::GenerateIdTokenRequest const& request) {
        return stub_->GenerateIdToken(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::credentials::v1::SignBlobResponse>
IAMCredentialsConnectionImpl::SignBlob(
    google::iam::credentials::v1::SignBlobRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(), idempotency_policy()->SignBlob(request),
      [this](grpc::ClientContext& context,
             google::iam::credentials::v1::SignBlobRequest const& request) {
        return stub_->SignBlob(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::credentials::v1::SignJwtResponse>
IAMCredentialsConnectionImpl::SignJwt(
    google::iam::credentials::v1::SignJwtRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(), idempotency_policy()->SignJwt(request),
      [this](grpc::ClientContext& context,
             google::iam::credentials::v1::SignJwtRequest const& request) {
        return stub_->SignJwt(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
namespace gcpcxxV1 = GOOGLE_CLOUD_CPP_NS;  // NOLINT(misc-unused-alias-decls)
}  // namespace iam_internal
}  // namespace cloud
}  // namespace google
