// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gaming/v1/realms_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GAMESERVICES_REALMS_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GAMESERVICES_REALMS_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/internal/retry_policy.h"
#include "google/cloud/version.h"
#include <google/cloud/gaming/v1/realms_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace gameservices {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class RealmsServiceConnectionIdempotencyPolicy {
 public:
  virtual ~RealmsServiceConnectionIdempotencyPolicy() = 0;

  /// Create a new copy of this object.
  virtual std::unique_ptr<RealmsServiceConnectionIdempotencyPolicy> clone()
      const = 0;

  virtual google::cloud::Idempotency ListRealms(
      google::cloud::gaming::v1::ListRealmsRequest request) = 0;

  virtual google::cloud::Idempotency GetRealm(
      google::cloud::gaming::v1::GetRealmRequest const& request) = 0;

  virtual google::cloud::Idempotency CreateRealm(
      google::cloud::gaming::v1::CreateRealmRequest const& request) = 0;

  virtual google::cloud::Idempotency DeleteRealm(
      google::cloud::gaming::v1::DeleteRealmRequest const& request) = 0;

  virtual google::cloud::Idempotency UpdateRealm(
      google::cloud::gaming::v1::UpdateRealmRequest const& request) = 0;

  virtual google::cloud::Idempotency PreviewRealmUpdate(
      google::cloud::gaming::v1::PreviewRealmUpdateRequest const& request) = 0;
};

std::unique_ptr<RealmsServiceConnectionIdempotencyPolicy>
MakeDefaultRealmsServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gameservices
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GAMESERVICES_REALMS_CONNECTION_IDEMPOTENCY_POLICY_H
