// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gaming/v1/realms_service.proto

#include "google/cloud/gameservices/realms_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace gameservices {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

RealmsServiceConnectionIdempotencyPolicy::
    ~RealmsServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultRealmsServiceConnectionIdempotencyPolicy
    : public RealmsServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultRealmsServiceConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<RealmsServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultRealmsServiceConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency ListRealms(
      google::cloud::gaming::v1::ListRealmsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetRealm(
      google::cloud::gaming::v1::GetRealmRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateRealm(
      google::cloud::gaming::v1::CreateRealmRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteRealm(
      google::cloud::gaming::v1::DeleteRealmRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateRealm(
      google::cloud::gaming::v1::UpdateRealmRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency PreviewRealmUpdate(
      google::cloud::gaming::v1::PreviewRealmUpdateRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<RealmsServiceConnectionIdempotencyPolicy>
MakeDefaultRealmsServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultRealmsServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gameservices
}  // namespace cloud
}  // namespace google
