// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gaming/v1/realms_service.proto

#include "google/cloud/gameservices/internal/realms_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/cloud/gaming/v1/realms_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace gameservices_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RealmsServiceMetadata::RealmsServiceMetadata(
    std::shared_ptr<RealmsServiceStub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::cloud::gaming::v1::ListRealmsResponse>
RealmsServiceMetadata::ListRealms(
    grpc::ClientContext& context,
    google::cloud::gaming::v1::ListRealmsRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListRealms(context, request);
}

StatusOr<google::cloud::gaming::v1::Realm> RealmsServiceMetadata::GetRealm(
    grpc::ClientContext& context,
    google::cloud::gaming::v1::GetRealmRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetRealm(context, request);
}

future<StatusOr<google::longrunning::Operation>>
RealmsServiceMetadata::AsyncCreateRealm(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::gaming::v1::CreateRealmRequest const& request) {
  SetMetadata(*context, "parent=" + request.parent());
  return child_->AsyncCreateRealm(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
RealmsServiceMetadata::AsyncDeleteRealm(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::gaming::v1::DeleteRealmRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncDeleteRealm(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
RealmsServiceMetadata::AsyncUpdateRealm(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::gaming::v1::UpdateRealmRequest const& request) {
  SetMetadata(*context, "realm.name=" + request.realm().name());
  return child_->AsyncUpdateRealm(cq, std::move(context), request);
}

StatusOr<google::cloud::gaming::v1::PreviewRealmUpdateResponse>
RealmsServiceMetadata::PreviewRealmUpdate(
    grpc::ClientContext& context,
    google::cloud::gaming::v1::PreviewRealmUpdateRequest const& request) {
  SetMetadata(context, "realm.name=" + request.realm().name());
  return child_->PreviewRealmUpdate(context, request);
}

future<StatusOr<google::longrunning::Operation>>
RealmsServiceMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncGetOperation(cq, std::move(context), request);
}

future<Status> RealmsServiceMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncCancelOperation(cq, std::move(context), request);
}

void RealmsServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                        std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void RealmsServiceMetadata::SetMetadata(grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gameservices_internal
}  // namespace cloud
}  // namespace google
