// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gaming/v1/realms_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GAMESERVICES_INTERNAL_REALMS_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GAMESERVICES_INTERNAL_REALMS_CONNECTION_IMPL_H

#include "google/cloud/gameservices/internal/realms_retry_traits.h"
#include "google/cloud/gameservices/internal/realms_stub.h"
#include "google/cloud/gameservices/realms_connection.h"
#include "google/cloud/gameservices/realms_connection_idempotency_policy.h"
#include "google/cloud/gameservices/realms_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace gameservices_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class RealmsServiceConnectionImpl
    : public gameservices::RealmsServiceConnection {
 public:
  ~RealmsServiceConnectionImpl() override = default;

  RealmsServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<gameservices_internal::RealmsServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<google::cloud::gaming::v1::Realm> ListRealms(
      google::cloud::gaming::v1::ListRealmsRequest request) override;

  StatusOr<google::cloud::gaming::v1::Realm> GetRealm(
      google::cloud::gaming::v1::GetRealmRequest const& request) override;

  future<StatusOr<google::cloud::gaming::v1::Realm>> CreateRealm(
      google::cloud::gaming::v1::CreateRealmRequest const& request) override;

  future<StatusOr<google::cloud::gaming::v1::OperationMetadata>> DeleteRealm(
      google::cloud::gaming::v1::DeleteRealmRequest const& request) override;

  future<StatusOr<google::cloud::gaming::v1::Realm>> UpdateRealm(
      google::cloud::gaming::v1::UpdateRealmRequest const& request) override;

  StatusOr<google::cloud::gaming::v1::PreviewRealmUpdateResponse>
  PreviewRealmUpdate(google::cloud::gaming::v1::PreviewRealmUpdateRequest const&
                         request) override;

 private:
  std::unique_ptr<gameservices::RealmsServiceRetryPolicy> retry_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<gameservices::RealmsServiceRetryPolicyOption>()) {
      return options.get<gameservices::RealmsServiceRetryPolicyOption>()
          ->clone();
    }
    return options_.get<gameservices::RealmsServiceRetryPolicyOption>()
        ->clone();
  }

  std::unique_ptr<BackoffPolicy> backoff_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<gameservices::RealmsServiceBackoffPolicyOption>()) {
      return options.get<gameservices::RealmsServiceBackoffPolicyOption>()
          ->clone();
    }
    return options_.get<gameservices::RealmsServiceBackoffPolicyOption>()
        ->clone();
  }

  std::unique_ptr<gameservices::RealmsServiceConnectionIdempotencyPolicy>
  idempotency_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<
            gameservices::RealmsServiceConnectionIdempotencyPolicyOption>()) {
      return options
          .get<gameservices::RealmsServiceConnectionIdempotencyPolicyOption>()
          ->clone();
    }
    return options_
        .get<gameservices::RealmsServiceConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  std::unique_ptr<PollingPolicy> polling_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<gameservices::RealmsServicePollingPolicyOption>()) {
      return options.get<gameservices::RealmsServicePollingPolicyOption>()
          ->clone();
    }
    return options_.get<gameservices::RealmsServicePollingPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<gameservices_internal::RealmsServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gameservices_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GAMESERVICES_INTERNAL_REALMS_CONNECTION_IMPL_H
