// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gaming/v1/game_server_deployments_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GAMESERVICES_INTERNAL_GAME_SERVER_DEPLOYMENTS_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GAMESERVICES_INTERNAL_GAME_SERVER_DEPLOYMENTS_CONNECTION_IMPL_H

#include "google/cloud/gameservices/game_server_deployments_connection.h"
#include "google/cloud/gameservices/game_server_deployments_connection_idempotency_policy.h"
#include "google/cloud/gameservices/game_server_deployments_options.h"
#include "google/cloud/gameservices/internal/game_server_deployments_retry_traits.h"
#include "google/cloud/gameservices/internal/game_server_deployments_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace gameservices_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class GameServerDeploymentsServiceConnectionImpl
    : public gameservices::GameServerDeploymentsServiceConnection {
 public:
  ~GameServerDeploymentsServiceConnectionImpl() override = default;

  GameServerDeploymentsServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<gameservices_internal::GameServerDeploymentsServiceStub>
          stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<google::cloud::gaming::v1::GameServerDeployment>
  ListGameServerDeployments(
      google::cloud::gaming::v1::ListGameServerDeploymentsRequest request)
      override;

  StatusOr<google::cloud::gaming::v1::GameServerDeployment>
  GetGameServerDeployment(
      google::cloud::gaming::v1::GetGameServerDeploymentRequest const& request)
      override;

  future<StatusOr<google::cloud::gaming::v1::GameServerDeployment>>
  CreateGameServerDeployment(
      google::cloud::gaming::v1::CreateGameServerDeploymentRequest const&
          request) override;

  future<StatusOr<google::cloud::gaming::v1::OperationMetadata>>
  DeleteGameServerDeployment(
      google::cloud::gaming::v1::DeleteGameServerDeploymentRequest const&
          request) override;

  future<StatusOr<google::cloud::gaming::v1::GameServerDeployment>>
  UpdateGameServerDeployment(
      google::cloud::gaming::v1::UpdateGameServerDeploymentRequest const&
          request) override;

  StatusOr<google::cloud::gaming::v1::GameServerDeploymentRollout>
  GetGameServerDeploymentRollout(
      google::cloud::gaming::v1::GetGameServerDeploymentRolloutRequest const&
          request) override;

  future<StatusOr<google::cloud::gaming::v1::GameServerDeployment>>
  UpdateGameServerDeploymentRollout(
      google::cloud::gaming::v1::UpdateGameServerDeploymentRolloutRequest const&
          request) override;

  StatusOr<
      google::cloud::gaming::v1::PreviewGameServerDeploymentRolloutResponse>
  PreviewGameServerDeploymentRollout(
      google::cloud::gaming::v1::
          PreviewGameServerDeploymentRolloutRequest const& request) override;

  StatusOr<google::cloud::gaming::v1::FetchDeploymentStateResponse>
  FetchDeploymentState(
      google::cloud::gaming::v1::FetchDeploymentStateRequest const& request)
      override;

 private:
  std::unique_ptr<gameservices::GameServerDeploymentsServiceRetryPolicy>
  retry_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<
            gameservices::GameServerDeploymentsServiceRetryPolicyOption>()) {
      return options
          .get<gameservices::GameServerDeploymentsServiceRetryPolicyOption>()
          ->clone();
    }
    return options_
        .get<gameservices::GameServerDeploymentsServiceRetryPolicyOption>()
        ->clone();
  }

  std::unique_ptr<BackoffPolicy> backoff_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<
            gameservices::GameServerDeploymentsServiceBackoffPolicyOption>()) {
      return options
          .get<gameservices::GameServerDeploymentsServiceBackoffPolicyOption>()
          ->clone();
    }
    return options_
        .get<gameservices::GameServerDeploymentsServiceBackoffPolicyOption>()
        ->clone();
  }

  std::unique_ptr<
      gameservices::GameServerDeploymentsServiceConnectionIdempotencyPolicy>
  idempotency_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<
            gameservices::
                GameServerDeploymentsServiceConnectionIdempotencyPolicyOption>()) {
      return options
          .get<
              gameservices::
                  GameServerDeploymentsServiceConnectionIdempotencyPolicyOption>()
          ->clone();
    }
    return options_
        .get<
            gameservices::
                GameServerDeploymentsServiceConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  std::unique_ptr<PollingPolicy> polling_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<
            gameservices::GameServerDeploymentsServicePollingPolicyOption>()) {
      return options
          .get<gameservices::GameServerDeploymentsServicePollingPolicyOption>()
          ->clone();
    }
    return options_
        .get<gameservices::GameServerDeploymentsServicePollingPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<gameservices_internal::GameServerDeploymentsServiceStub>
      stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gameservices_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GAMESERVICES_INTERNAL_GAME_SERVER_DEPLOYMENTS_CONNECTION_IMPL_H
