// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gaming/v1/game_server_configs_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GAMESERVICES_INTERNAL_GAME_SERVER_CONFIGS_METADATA_DECORATOR_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GAMESERVICES_INTERNAL_GAME_SERVER_CONFIGS_METADATA_DECORATOR_H

#include "google/cloud/gameservices/internal/game_server_configs_stub.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace gameservices_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class GameServerConfigsServiceMetadata : public GameServerConfigsServiceStub {
 public:
  ~GameServerConfigsServiceMetadata() override = default;
  explicit GameServerConfigsServiceMetadata(
      std::shared_ptr<GameServerConfigsServiceStub> child);

  StatusOr<google::cloud::gaming::v1::ListGameServerConfigsResponse>
  ListGameServerConfigs(
      grpc::ClientContext& context,
      google::cloud::gaming::v1::ListGameServerConfigsRequest const& request)
      override;

  StatusOr<google::cloud::gaming::v1::GameServerConfig> GetGameServerConfig(
      grpc::ClientContext& context,
      google::cloud::gaming::v1::GetGameServerConfigRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateGameServerConfig(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::cloud::gaming::v1::CreateGameServerConfigRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteGameServerConfig(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::cloud::gaming::v1::DeleteGameServerConfigRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  void SetMetadata(grpc::ClientContext& context,
                   std::string const& request_params);
  void SetMetadata(grpc::ClientContext& context);

  std::shared_ptr<GameServerConfigsServiceStub> child_;
  std::string api_client_header_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gameservices_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GAMESERVICES_INTERNAL_GAME_SERVER_CONFIGS_METADATA_DECORATOR_H
