// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gaming/v1/game_server_configs_service.proto

#include "google/cloud/gameservices/internal/game_server_configs_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/cloud/gaming/v1/game_server_configs_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace gameservices_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GameServerConfigsServiceMetadata::GameServerConfigsServiceMetadata(
    std::shared_ptr<GameServerConfigsServiceStub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::cloud::gaming::v1::ListGameServerConfigsResponse>
GameServerConfigsServiceMetadata::ListGameServerConfigs(
    grpc::ClientContext& context,
    google::cloud::gaming::v1::ListGameServerConfigsRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListGameServerConfigs(context, request);
}

StatusOr<google::cloud::gaming::v1::GameServerConfig>
GameServerConfigsServiceMetadata::GetGameServerConfig(
    grpc::ClientContext& context,
    google::cloud::gaming::v1::GetGameServerConfigRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetGameServerConfig(context, request);
}

future<StatusOr<google::longrunning::Operation>>
GameServerConfigsServiceMetadata::AsyncCreateGameServerConfig(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::gaming::v1::CreateGameServerConfigRequest const& request) {
  SetMetadata(*context, "parent=" + request.parent());
  return child_->AsyncCreateGameServerConfig(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
GameServerConfigsServiceMetadata::AsyncDeleteGameServerConfig(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::gaming::v1::DeleteGameServerConfigRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncDeleteGameServerConfig(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
GameServerConfigsServiceMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncGetOperation(cq, std::move(context), request);
}

future<Status> GameServerConfigsServiceMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncCancelOperation(cq, std::move(context), request);
}

void GameServerConfigsServiceMetadata::SetMetadata(
    grpc::ClientContext& context, std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void GameServerConfigsServiceMetadata::SetMetadata(
    grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gameservices_internal
}  // namespace cloud
}  // namespace google
