// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gaming/v1/game_server_configs_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GAMESERVICES_INTERNAL_GAME_SERVER_CONFIGS_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GAMESERVICES_INTERNAL_GAME_SERVER_CONFIGS_CONNECTION_IMPL_H

#include "google/cloud/gameservices/game_server_configs_connection.h"
#include "google/cloud/gameservices/game_server_configs_connection_idempotency_policy.h"
#include "google/cloud/gameservices/game_server_configs_options.h"
#include "google/cloud/gameservices/internal/game_server_configs_retry_traits.h"
#include "google/cloud/gameservices/internal/game_server_configs_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace gameservices_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class GameServerConfigsServiceConnectionImpl
    : public gameservices::GameServerConfigsServiceConnection {
 public:
  ~GameServerConfigsServiceConnectionImpl() override = default;

  GameServerConfigsServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<gameservices_internal::GameServerConfigsServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<google::cloud::gaming::v1::GameServerConfig>
  ListGameServerConfigs(
      google::cloud::gaming::v1::ListGameServerConfigsRequest request) override;

  StatusOr<google::cloud::gaming::v1::GameServerConfig> GetGameServerConfig(
      google::cloud::gaming::v1::GetGameServerConfigRequest const& request)
      override;

  future<StatusOr<google::cloud::gaming::v1::GameServerConfig>>
  CreateGameServerConfig(
      google::cloud::gaming::v1::CreateGameServerConfigRequest const& request)
      override;

  future<StatusOr<google::cloud::gaming::v1::OperationMetadata>>
  DeleteGameServerConfig(
      google::cloud::gaming::v1::DeleteGameServerConfigRequest const& request)
      override;

 private:
  std::unique_ptr<gameservices::GameServerConfigsServiceRetryPolicy>
  retry_policy() {
    auto const& options = internal::CurrentOptions();
    if (options
            .has<gameservices::GameServerConfigsServiceRetryPolicyOption>()) {
      return options
          .get<gameservices::GameServerConfigsServiceRetryPolicyOption>()
          ->clone();
    }
    return options_
        .get<gameservices::GameServerConfigsServiceRetryPolicyOption>()
        ->clone();
  }

  std::unique_ptr<BackoffPolicy> backoff_policy() {
    auto const& options = internal::CurrentOptions();
    if (options
            .has<gameservices::GameServerConfigsServiceBackoffPolicyOption>()) {
      return options
          .get<gameservices::GameServerConfigsServiceBackoffPolicyOption>()
          ->clone();
    }
    return options_
        .get<gameservices::GameServerConfigsServiceBackoffPolicyOption>()
        ->clone();
  }

  std::unique_ptr<
      gameservices::GameServerConfigsServiceConnectionIdempotencyPolicy>
  idempotency_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<
            gameservices::
                GameServerConfigsServiceConnectionIdempotencyPolicyOption>()) {
      return options
          .get<gameservices::
                   GameServerConfigsServiceConnectionIdempotencyPolicyOption>()
          ->clone();
    }
    return options_
        .get<gameservices::
                 GameServerConfigsServiceConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  std::unique_ptr<PollingPolicy> polling_policy() {
    auto const& options = internal::CurrentOptions();
    if (options
            .has<gameservices::GameServerConfigsServicePollingPolicyOption>()) {
      return options
          .get<gameservices::GameServerConfigsServicePollingPolicyOption>()
          ->clone();
    }
    return options_
        .get<gameservices::GameServerConfigsServicePollingPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<gameservices_internal::GameServerConfigsServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gameservices_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GAMESERVICES_INTERNAL_GAME_SERVER_CONFIGS_CONNECTION_IMPL_H
