// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gaming/v1/game_server_clusters_service.proto

#include "google/cloud/gameservices/internal/game_server_clusters_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/cloud/gaming/v1/game_server_clusters_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace gameservices_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GameServerClustersServiceMetadata::GameServerClustersServiceMetadata(
    std::shared_ptr<GameServerClustersServiceStub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::cloud::gaming::v1::ListGameServerClustersResponse>
GameServerClustersServiceMetadata::ListGameServerClusters(
    grpc::ClientContext& context,
    google::cloud::gaming::v1::ListGameServerClustersRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListGameServerClusters(context, request);
}

StatusOr<google::cloud::gaming::v1::GameServerCluster>
GameServerClustersServiceMetadata::GetGameServerCluster(
    grpc::ClientContext& context,
    google::cloud::gaming::v1::GetGameServerClusterRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetGameServerCluster(context, request);
}

future<StatusOr<google::longrunning::Operation>>
GameServerClustersServiceMetadata::AsyncCreateGameServerCluster(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::gaming::v1::CreateGameServerClusterRequest const& request) {
  SetMetadata(*context, "parent=" + request.parent());
  return child_->AsyncCreateGameServerCluster(cq, std::move(context), request);
}

StatusOr<google::cloud::gaming::v1::PreviewCreateGameServerClusterResponse>
GameServerClustersServiceMetadata::PreviewCreateGameServerCluster(
    grpc::ClientContext& context,
    google::cloud::gaming::v1::PreviewCreateGameServerClusterRequest const&
        request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->PreviewCreateGameServerCluster(context, request);
}

future<StatusOr<google::longrunning::Operation>>
GameServerClustersServiceMetadata::AsyncDeleteGameServerCluster(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::gaming::v1::DeleteGameServerClusterRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncDeleteGameServerCluster(cq, std::move(context), request);
}

StatusOr<google::cloud::gaming::v1::PreviewDeleteGameServerClusterResponse>
GameServerClustersServiceMetadata::PreviewDeleteGameServerCluster(
    grpc::ClientContext& context,
    google::cloud::gaming::v1::PreviewDeleteGameServerClusterRequest const&
        request) {
  SetMetadata(context, "name=" + request.name());
  return child_->PreviewDeleteGameServerCluster(context, request);
}

future<StatusOr<google::longrunning::Operation>>
GameServerClustersServiceMetadata::AsyncUpdateGameServerCluster(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::gaming::v1::UpdateGameServerClusterRequest const& request) {
  SetMetadata(*context, "game_server_cluster.name=" +
                            request.game_server_cluster().name());
  return child_->AsyncUpdateGameServerCluster(cq, std::move(context), request);
}

StatusOr<google::cloud::gaming::v1::PreviewUpdateGameServerClusterResponse>
GameServerClustersServiceMetadata::PreviewUpdateGameServerCluster(
    grpc::ClientContext& context,
    google::cloud::gaming::v1::PreviewUpdateGameServerClusterRequest const&
        request) {
  SetMetadata(context, "game_server_cluster.name=" +
                           request.game_server_cluster().name());
  return child_->PreviewUpdateGameServerCluster(context, request);
}

future<StatusOr<google::longrunning::Operation>>
GameServerClustersServiceMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncGetOperation(cq, std::move(context), request);
}

future<Status> GameServerClustersServiceMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncCancelOperation(cq, std::move(context), request);
}

void GameServerClustersServiceMetadata::SetMetadata(
    grpc::ClientContext& context, std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void GameServerClustersServiceMetadata::SetMetadata(
    grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gameservices_internal
}  // namespace cloud
}  // namespace google
