// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gaming/v1/game_server_deployments_service.proto

#include "google/cloud/gameservices/game_server_deployments_connection.h"
#include "google/cloud/gameservices/game_server_deployments_options.h"
#include "google/cloud/gameservices/internal/game_server_deployments_connection_impl.h"
#include "google/cloud/gameservices/internal/game_server_deployments_option_defaults.h"
#include "google/cloud/gameservices/internal/game_server_deployments_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace gameservices {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GameServerDeploymentsServiceConnection::
    ~GameServerDeploymentsServiceConnection() = default;

StreamRange<google::cloud::gaming::v1::GameServerDeployment>
GameServerDeploymentsServiceConnection::ListGameServerDeployments(
    google::cloud::gaming::v1::ListGameServerDeploymentsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::gaming::v1::GameServerDeployment>>(
      std::move(request),
      [](google::cloud::gaming::v1::ListGameServerDeploymentsRequest const&) {
        return StatusOr<
            google::cloud::gaming::v1::ListGameServerDeploymentsResponse>{};
      },
      [](google::cloud::gaming::v1::ListGameServerDeploymentsResponse const&) {
        return std::vector<google::cloud::gaming::v1::GameServerDeployment>();
      });
}

StatusOr<google::cloud::gaming::v1::GameServerDeployment>
GameServerDeploymentsServiceConnection::GetGameServerDeployment(
    google::cloud::gaming::v1::GetGameServerDeploymentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::gaming::v1::GameServerDeployment>>
GameServerDeploymentsServiceConnection::CreateGameServerDeployment(
    google::cloud::gaming::v1::CreateGameServerDeploymentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gaming::v1::GameServerDeployment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gaming::v1::OperationMetadata>>
GameServerDeploymentsServiceConnection::DeleteGameServerDeployment(
    google::cloud::gaming::v1::DeleteGameServerDeploymentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gaming::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gaming::v1::GameServerDeployment>>
GameServerDeploymentsServiceConnection::UpdateGameServerDeployment(
    google::cloud::gaming::v1::UpdateGameServerDeploymentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gaming::v1::GameServerDeployment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::gaming::v1::GameServerDeploymentRollout>
GameServerDeploymentsServiceConnection::GetGameServerDeploymentRollout(
    google::cloud::gaming::v1::GetGameServerDeploymentRolloutRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::gaming::v1::GameServerDeployment>>
GameServerDeploymentsServiceConnection::UpdateGameServerDeploymentRollout(
    google::cloud::gaming::v1::
        UpdateGameServerDeploymentRolloutRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gaming::v1::GameServerDeployment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::gaming::v1::PreviewGameServerDeploymentRolloutResponse>
GameServerDeploymentsServiceConnection::PreviewGameServerDeploymentRollout(
    google::cloud::gaming::v1::
        PreviewGameServerDeploymentRolloutRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::gaming::v1::FetchDeploymentStateResponse>
GameServerDeploymentsServiceConnection::FetchDeploymentState(
    google::cloud::gaming::v1::FetchDeploymentStateRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<GameServerDeploymentsServiceConnection>
MakeGameServerDeploymentsServiceConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 GameServerDeploymentsServicePolicyOptionList>(
      options, __func__);
  options = gameservices_internal::GameServerDeploymentsServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub =
      gameservices_internal::CreateDefaultGameServerDeploymentsServiceStub(
          background->cq(), options);
  return std::make_shared<
      gameservices_internal::GameServerDeploymentsServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gameservices
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace gameservices_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<gameservices::GameServerDeploymentsServiceConnection>
MakeGameServerDeploymentsServiceConnection(
    std::shared_ptr<GameServerDeploymentsServiceStub> stub, Options options) {
  options = GameServerDeploymentsServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<
      gameservices_internal::GameServerDeploymentsServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gameservices_internal
}  // namespace cloud
}  // namespace google
