// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gaming/v1/game_server_deployments_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GAMESERVICES_GAME_SERVER_DEPLOYMENTS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GAMESERVICES_GAME_SERVER_DEPLOYMENTS_CLIENT_H

#include "google/cloud/gameservices/game_server_deployments_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace gameservices {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// The game server deployment is used to control the deployment of Agones
/// fleets.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class GameServerDeploymentsServiceClient {
 public:
  explicit GameServerDeploymentsServiceClient(
      std::shared_ptr<GameServerDeploymentsServiceConnection> connection,
      Options options = {});
  ~GameServerDeploymentsServiceClient();

  //@{
  // @name Copy and move support
  GameServerDeploymentsServiceClient(
      GameServerDeploymentsServiceClient const&) = default;
  GameServerDeploymentsServiceClient& operator=(
      GameServerDeploymentsServiceClient const&) = default;
  GameServerDeploymentsServiceClient(GameServerDeploymentsServiceClient&&) =
      default;
  GameServerDeploymentsServiceClient& operator=(
      GameServerDeploymentsServiceClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(GameServerDeploymentsServiceClient const& a,
                         GameServerDeploymentsServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(GameServerDeploymentsServiceClient const& a,
                         GameServerDeploymentsServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Lists game server deployments in a given project and location.
  ///
  /// @param parent  Required. The parent resource name, in the following form:
  ///  `projects/{project}/locations/{location}`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::gaming::v1::GameServerDeployment,google/cloud/gaming/v1/game_server_deployments.proto#L181}
  ///
  /// [google.cloud.gaming.v1.ListGameServerDeploymentsRequest]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L31}
  /// [google.cloud.gaming.v1.GameServerDeployment]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L181}
  ///
  StreamRange<google::cloud::gaming::v1::GameServerDeployment>
  ListGameServerDeployments(std::string const& parent, Options options = {});

  ///
  /// Lists game server deployments in a given project and location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::gaming::v1::ListGameServerDeploymentsRequest,google/cloud/gaming/v1/game_server_deployments.proto#L31}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::gaming::v1::GameServerDeployment,google/cloud/gaming/v1/game_server_deployments.proto#L181}
  ///
  /// [google.cloud.gaming.v1.ListGameServerDeploymentsRequest]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L31}
  /// [google.cloud.gaming.v1.GameServerDeployment]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L181}
  ///
  StreamRange<google::cloud::gaming::v1::GameServerDeployment>
  ListGameServerDeployments(
      google::cloud::gaming::v1::ListGameServerDeploymentsRequest request,
      Options options = {});

  ///
  /// Gets details of a single game server deployment.
  ///
  /// @param name  Required. The name of the game server delpoyment to retrieve,
  /// in the following form:
  ///  `projects/{project}/locations/{location}/gameServerDeployments/{deployment}`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::gaming::v1::GameServerDeployment,google/cloud/gaming/v1/game_server_deployments.proto#L181}
  ///
  /// [google.cloud.gaming.v1.GetGameServerDeploymentRequest]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L74}
  /// [google.cloud.gaming.v1.GameServerDeployment]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L181}
  ///
  StatusOr<google::cloud::gaming::v1::GameServerDeployment>
  GetGameServerDeployment(std::string const& name, Options options = {});

  ///
  /// Gets details of a single game server deployment.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::gaming::v1::GetGameServerDeploymentRequest,google/cloud/gaming/v1/game_server_deployments.proto#L74}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::gaming::v1::GameServerDeployment,google/cloud/gaming/v1/game_server_deployments.proto#L181}
  ///
  /// [google.cloud.gaming.v1.GetGameServerDeploymentRequest]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L74}
  /// [google.cloud.gaming.v1.GameServerDeployment]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L181}
  ///
  StatusOr<google::cloud::gaming::v1::GameServerDeployment>
  GetGameServerDeployment(
      google::cloud::gaming::v1::GetGameServerDeploymentRequest const& request,
      Options options = {});

  ///
  /// Creates a new game server deployment in a given project and location.
  ///
  /// @param parent  Required. The parent resource name, in the following form:
  ///  `projects/{project}/locations/{location}`.
  /// @param game_server_deployment  Required. The game server delpoyment
  /// resource to be created.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::gaming::v1::GameServerDeployment,google/cloud/gaming/v1/game_server_deployments.proto#L181}
  ///
  /// [google.cloud.gaming.v1.CreateGameServerDeploymentRequest]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L99}
  /// [google.cloud.gaming.v1.GameServerDeployment]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L181}
  ///
  future<StatusOr<google::cloud::gaming::v1::GameServerDeployment>>
  CreateGameServerDeployment(
      std::string const& parent,
      google::cloud::gaming::v1::GameServerDeployment const&
          game_server_deployment,
      Options options = {});

  ///
  /// Creates a new game server deployment in a given project and location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::gaming::v1::CreateGameServerDeploymentRequest,google/cloud/gaming/v1/game_server_deployments.proto#L99}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::gaming::v1::GameServerDeployment,google/cloud/gaming/v1/game_server_deployments.proto#L181}
  ///
  /// [google.cloud.gaming.v1.CreateGameServerDeploymentRequest]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L99}
  /// [google.cloud.gaming.v1.GameServerDeployment]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L181}
  ///
  future<StatusOr<google::cloud::gaming::v1::GameServerDeployment>>
  CreateGameServerDeployment(
      google::cloud::gaming::v1::CreateGameServerDeploymentRequest const&
          request,
      Options options = {});

  ///
  /// Deletes a single game server deployment.
  ///
  /// @param name  Required. The name of the game server delpoyment to delete,
  /// in the following form:
  ///  `projects/{project}/locations/{location}/gameServerDeployments/{deployment}`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::gaming::v1::OperationMetadata,google/cloud/gaming/v1/common.proto#L29}
  ///
  /// [google.cloud.gaming.v1.DeleteGameServerDeploymentRequest]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L117}
  /// [google.cloud.gaming.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/common.proto#L29}
  ///
  future<StatusOr<google::cloud::gaming::v1::OperationMetadata>>
  DeleteGameServerDeployment(std::string const& name, Options options = {});

  ///
  /// Deletes a single game server deployment.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::gaming::v1::DeleteGameServerDeploymentRequest,google/cloud/gaming/v1/game_server_deployments.proto#L117}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::gaming::v1::OperationMetadata,google/cloud/gaming/v1/common.proto#L29}
  ///
  /// [google.cloud.gaming.v1.DeleteGameServerDeploymentRequest]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L117}
  /// [google.cloud.gaming.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/common.proto#L29}
  ///
  future<StatusOr<google::cloud::gaming::v1::OperationMetadata>>
  DeleteGameServerDeployment(
      google::cloud::gaming::v1::DeleteGameServerDeploymentRequest const&
          request,
      Options options = {});

  ///
  /// Patches a game server deployment.
  ///
  /// @param game_server_deployment  Required. The game server delpoyment to be
  /// updated.
  ///  Only fields specified in update_mask are updated.
  /// @param update_mask  Required. Mask of fields to update. At least one path
  /// must be supplied in
  ///  this field. For the `FieldMask` definition, see
  ///  https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::gaming::v1::GameServerDeployment,google/cloud/gaming/v1/game_server_deployments.proto#L181}
  ///
  /// [google.cloud.gaming.v1.UpdateGameServerDeploymentRequest]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L130}
  /// [google.cloud.gaming.v1.GameServerDeployment]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L181}
  ///
  future<StatusOr<google::cloud::gaming::v1::GameServerDeployment>>
  UpdateGameServerDeployment(
      google::cloud::gaming::v1::GameServerDeployment const&
          game_server_deployment,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Patches a game server deployment.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::gaming::v1::UpdateGameServerDeploymentRequest,google/cloud/gaming/v1/game_server_deployments.proto#L130}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::gaming::v1::GameServerDeployment,google/cloud/gaming/v1/game_server_deployments.proto#L181}
  ///
  /// [google.cloud.gaming.v1.UpdateGameServerDeploymentRequest]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L130}
  /// [google.cloud.gaming.v1.GameServerDeployment]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L181}
  ///
  future<StatusOr<google::cloud::gaming::v1::GameServerDeployment>>
  UpdateGameServerDeployment(
      google::cloud::gaming::v1::UpdateGameServerDeploymentRequest const&
          request,
      Options options = {});

  ///
  /// Gets details a single game server deployment rollout.
  ///
  /// @param name  Required. The name of the game server delpoyment to retrieve,
  /// in the following form:
  ///  `projects/{project}/locations/{location}/gameServerDeployments/{deployment}/rollout`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::gaming::v1::GameServerDeploymentRollout,google/cloud/gaming/v1/game_server_deployments.proto#L227}
  ///
  /// [google.cloud.gaming.v1.GetGameServerDeploymentRolloutRequest]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L87}
  /// [google.cloud.gaming.v1.GameServerDeploymentRollout]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L227}
  ///
  StatusOr<google::cloud::gaming::v1::GameServerDeploymentRollout>
  GetGameServerDeploymentRollout(std::string const& name, Options options = {});

  ///
  /// Gets details a single game server deployment rollout.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::gaming::v1::GetGameServerDeploymentRolloutRequest,google/cloud/gaming/v1/game_server_deployments.proto#L87}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::gaming::v1::GameServerDeploymentRollout,google/cloud/gaming/v1/game_server_deployments.proto#L227}
  ///
  /// [google.cloud.gaming.v1.GetGameServerDeploymentRolloutRequest]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L87}
  /// [google.cloud.gaming.v1.GameServerDeploymentRollout]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L227}
  ///
  StatusOr<google::cloud::gaming::v1::GameServerDeploymentRollout>
  GetGameServerDeploymentRollout(
      google::cloud::gaming::v1::GetGameServerDeploymentRolloutRequest const&
          request,
      Options options = {});

  ///
  /// Patches a single game server deployment rollout.
  /// The method will not return an error if the update does not affect any
  /// existing realms. For example - if the default_game_server_config is
  /// changed but all existing realms use the override, that is valid.
  /// Similarly, if a non existing realm is explicitly called out in
  /// game_server_config_overrides field, that will also not result in an error.
  ///
  /// @param rollout  Required. The game server delpoyment rollout to be
  /// updated.
  ///  Only fields specified in update_mask are updated.
  /// @param update_mask  Required. Mask of fields to update. At least one path
  /// must be supplied in
  ///  this field. For the `FieldMask` definition, see
  ///  https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::gaming::v1::GameServerDeployment,google/cloud/gaming/v1/game_server_deployments.proto#L181}
  ///
  /// [google.cloud.gaming.v1.UpdateGameServerDeploymentRolloutRequest]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L143}
  /// [google.cloud.gaming.v1.GameServerDeployment]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L181}
  ///
  future<StatusOr<google::cloud::gaming::v1::GameServerDeployment>>
  UpdateGameServerDeploymentRollout(
      google::cloud::gaming::v1::GameServerDeploymentRollout const& rollout,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Patches a single game server deployment rollout.
  /// The method will not return an error if the update does not affect any
  /// existing realms. For example - if the default_game_server_config is
  /// changed but all existing realms use the override, that is valid.
  /// Similarly, if a non existing realm is explicitly called out in
  /// game_server_config_overrides field, that will also not result in an error.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::gaming::v1::UpdateGameServerDeploymentRolloutRequest,google/cloud/gaming/v1/game_server_deployments.proto#L143}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::gaming::v1::GameServerDeployment,google/cloud/gaming/v1/game_server_deployments.proto#L181}
  ///
  /// [google.cloud.gaming.v1.UpdateGameServerDeploymentRolloutRequest]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L143}
  /// [google.cloud.gaming.v1.GameServerDeployment]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L181}
  ///
  future<StatusOr<google::cloud::gaming::v1::GameServerDeployment>>
  UpdateGameServerDeploymentRollout(
      google::cloud::gaming::v1::UpdateGameServerDeploymentRolloutRequest const&
          request,
      Options options = {});

  ///
  /// Previews the game server deployment rollout. This API does not mutate the
  /// rollout resource.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::gaming::v1::PreviewGameServerDeploymentRolloutRequest,google/cloud/gaming/v1/game_server_deployments.proto#L261}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::gaming::v1::PreviewGameServerDeploymentRolloutResponse,google/cloud/gaming/v1/game_server_deployments.proto#L278}
  ///
  /// [google.cloud.gaming.v1.PreviewGameServerDeploymentRolloutRequest]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L261}
  /// [google.cloud.gaming.v1.PreviewGameServerDeploymentRolloutResponse]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L278}
  ///
  StatusOr<
      google::cloud::gaming::v1::PreviewGameServerDeploymentRolloutResponse>
  PreviewGameServerDeploymentRollout(
      google::cloud::gaming::v1::
          PreviewGameServerDeploymentRolloutRequest const& request,
      Options options = {});

  ///
  /// Retrieves information about the current state of the game server
  /// deployment. Gathers all the Agones fleets and Agones autoscalers,
  /// including fleets running an older version of the game server deployment.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::gaming::v1::FetchDeploymentStateRequest,google/cloud/gaming/v1/game_server_deployments.proto#L155}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::gaming::v1::FetchDeploymentStateResponse,google/cloud/gaming/v1/game_server_deployments.proto#L162}
  ///
  /// [google.cloud.gaming.v1.FetchDeploymentStateRequest]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L155}
  /// [google.cloud.gaming.v1.FetchDeploymentStateResponse]:
  /// @googleapis_reference_link{google/cloud/gaming/v1/game_server_deployments.proto#L162}
  ///
  StatusOr<google::cloud::gaming::v1::FetchDeploymentStateResponse>
  FetchDeploymentState(
      google::cloud::gaming::v1::FetchDeploymentStateRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<GameServerDeploymentsServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gameservices
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GAMESERVICES_GAME_SERVER_DEPLOYMENTS_CLIENT_H
