// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gaming/v1/game_server_configs_service.proto

#include "google/cloud/gameservices/game_server_configs_connection.h"
#include "google/cloud/gameservices/game_server_configs_options.h"
#include "google/cloud/gameservices/internal/game_server_configs_connection_impl.h"
#include "google/cloud/gameservices/internal/game_server_configs_option_defaults.h"
#include "google/cloud/gameservices/internal/game_server_configs_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace gameservices {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GameServerConfigsServiceConnection::~GameServerConfigsServiceConnection() =
    default;

StreamRange<google::cloud::gaming::v1::GameServerConfig>
GameServerConfigsServiceConnection::ListGameServerConfigs(
    google::cloud::gaming::v1::ListGameServerConfigsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::gaming::v1::GameServerConfig>>(
      std::move(request),
      [](google::cloud::gaming::v1::ListGameServerConfigsRequest const&) {
        return StatusOr<
            google::cloud::gaming::v1::ListGameServerConfigsResponse>{};
      },
      [](google::cloud::gaming::v1::ListGameServerConfigsResponse const&) {
        return std::vector<google::cloud::gaming::v1::GameServerConfig>();
      });
}

StatusOr<google::cloud::gaming::v1::GameServerConfig>
GameServerConfigsServiceConnection::GetGameServerConfig(
    google::cloud::gaming::v1::GetGameServerConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::gaming::v1::GameServerConfig>>
GameServerConfigsServiceConnection::CreateGameServerConfig(
    google::cloud::gaming::v1::CreateGameServerConfigRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gaming::v1::GameServerConfig>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::gaming::v1::OperationMetadata>>
GameServerConfigsServiceConnection::DeleteGameServerConfig(
    google::cloud::gaming::v1::DeleteGameServerConfigRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::gaming::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<GameServerConfigsServiceConnection>
MakeGameServerConfigsServiceConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 GameServerConfigsServicePolicyOptionList>(
      options, __func__);
  options = gameservices_internal::GameServerConfigsServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = gameservices_internal::CreateDefaultGameServerConfigsServiceStub(
      background->cq(), options);
  return std::make_shared<
      gameservices_internal::GameServerConfigsServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gameservices
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace gameservices_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<gameservices::GameServerConfigsServiceConnection>
MakeGameServerConfigsServiceConnection(
    std::shared_ptr<GameServerConfigsServiceStub> stub, Options options) {
  options = GameServerConfigsServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<
      gameservices_internal::GameServerConfigsServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gameservices_internal
}  // namespace cloud
}  // namespace google
