// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gaming/v1/game_server_configs_service.proto

#include "google/cloud/gameservices/game_server_configs_client.h"
#include "google/cloud/gameservices/internal/game_server_configs_option_defaults.h"
#include <memory>

namespace google {
namespace cloud {
namespace gameservices {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GameServerConfigsServiceClient::GameServerConfigsServiceClient(
    std::shared_ptr<GameServerConfigsServiceConnection> connection,
    Options options)
    : connection_(std::move(connection)),
      options_(internal::MergeOptions(
          std::move(options),
          gameservices_internal::GameServerConfigsServiceDefaultOptions(
              connection_->options()))) {}
GameServerConfigsServiceClient::~GameServerConfigsServiceClient() = default;

StreamRange<google::cloud::gaming::v1::GameServerConfig>
GameServerConfigsServiceClient::ListGameServerConfigs(std::string const& parent,
                                                      Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::gaming::v1::ListGameServerConfigsRequest request;
  request.set_parent(parent);
  return connection_->ListGameServerConfigs(request);
}

StreamRange<google::cloud::gaming::v1::GameServerConfig>
GameServerConfigsServiceClient::ListGameServerConfigs(
    google::cloud::gaming::v1::ListGameServerConfigsRequest request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListGameServerConfigs(std::move(request));
}

StatusOr<google::cloud::gaming::v1::GameServerConfig>
GameServerConfigsServiceClient::GetGameServerConfig(std::string const& name,
                                                    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::gaming::v1::GetGameServerConfigRequest request;
  request.set_name(name);
  return connection_->GetGameServerConfig(request);
}

StatusOr<google::cloud::gaming::v1::GameServerConfig>
GameServerConfigsServiceClient::GetGameServerConfig(
    google::cloud::gaming::v1::GetGameServerConfigRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetGameServerConfig(request);
}

future<StatusOr<google::cloud::gaming::v1::GameServerConfig>>
GameServerConfigsServiceClient::CreateGameServerConfig(
    std::string const& parent,
    google::cloud::gaming::v1::GameServerConfig const& game_server_config,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::gaming::v1::CreateGameServerConfigRequest request;
  request.set_parent(parent);
  *request.mutable_game_server_config() = game_server_config;
  return connection_->CreateGameServerConfig(request);
}

future<StatusOr<google::cloud::gaming::v1::GameServerConfig>>
GameServerConfigsServiceClient::CreateGameServerConfig(
    google::cloud::gaming::v1::CreateGameServerConfigRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CreateGameServerConfig(request);
}

future<StatusOr<google::cloud::gaming::v1::OperationMetadata>>
GameServerConfigsServiceClient::DeleteGameServerConfig(std::string const& name,
                                                       Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::gaming::v1::DeleteGameServerConfigRequest request;
  request.set_name(name);
  return connection_->DeleteGameServerConfig(request);
}

future<StatusOr<google::cloud::gaming::v1::OperationMetadata>>
GameServerConfigsServiceClient::DeleteGameServerConfig(
    google::cloud::gaming::v1::DeleteGameServerConfigRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeleteGameServerConfig(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gameservices
}  // namespace cloud
}  // namespace google
